/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident.physics_projectile;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractPhysicsThrowingProjectile;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.entity.explosion.NapalmExplosion;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlastBarrel
extends BrutalityAbstractPhysicsThrowingProjectile
implements BrutalityGeoEntity {
    public BlastBarrel(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public BlastBarrel(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    @Override
    public float getModelHeight() {
        return 16.0f;
    }

    @Override
    @NotNull
    public SoundEvent m_36784_() {
        return ModUtils.getRandomSound(BrutalityModSounds.CRATE_BREAK_SOUNDS);
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return ModUtils.getRandomSound(BrutalityModSounds.CRATE_BREAK_SOUNDS);
    }

    @Override
    protected float getBounciness() {
        return 0.5f;
    }

    @Override
    protected int getBounceQuota() {
        return 2;
    }

    @Override
    public float getGravity() {
        return 0.065f;
    }

    @Override
    public void m_8119_() {
        if (this.f_19797_ >= 100) {
            Vec3 loc = this.m_20318_(1.0f);
            this.explode(loc);
            this.m_146870_();
        }
        super.m_8119_();
    }

    @Override
    protected void onFinalBounce(HitResult result) {
        Vec3 loc = result.m_82450_();
        this.explode(loc);
    }

    @Override
    protected boolean shouldDiscardAfterBounce() {
        return true;
    }

    private void explode(Vec3 loc) {
        NapalmExplosion explosion = new NapalmExplosion(this.m_9236_(), this.m_19749_(), null, null, loc.f_82479_, loc.f_82480_, loc.f_82481_, 3.0f, true, ModUtils.getThrowingWeaponExplosionInteractionFromConfig());
        explosion.setEntityFilter(e -> e != this.m_19749_());
        ModExplosionHelper.Server.explode(explosion, this.m_9236_(), true);
    }
}

