/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.projectile.trident.physics_projectile;

import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.entity.projectile.trident.physics_projectile.Toast;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityDamageTypes;
import net.goo.brutality.registry.BrutalityModEntities;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class OverclockedToaster
extends BrutalityAbstractThrowingProjectile
implements BrutalityGeoEntity {
    private int lastAnim = 1;

    public OverclockedToaster(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, pLevel, damageTypeResourceKey);
    }

    public OverclockedToaster(EntityType<? extends BrutalityAbstractThrowingProjectile> pEntityType, Player player, Level pLevel, ResourceKey<DamageType> damageTypeResourceKey) {
        super(pEntityType, player, pLevel, damageTypeResourceKey);
    }

    @Override
    public int getInGroundLifespan() {
        return 200;
    }

    @Override
    @NotNull
    public SoundEvent m_36784_() {
        return SoundEvents.f_12064_;
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12064_;
    }

    @Override
    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        if (this.f_19797_ % 5 == 0 && (entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.f_36703_) {
                LivingEntity nearest = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.f_26872_, livingEntity, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(10.0));
                if (nearest == null) {
                    return;
                }
                Toast toast = new Toast((EntityType<? extends BrutalityAbstractThrowingProjectile>)((EntityType)BrutalityModEntities.TOAST.get()), this.m_9236_(), BrutalityDamageTypes.THROWING_PIERCE);
                toast.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                Vec3 target = nearest.m_20318_(1.0f).m_82520_(0.0, (double)(nearest.m_20206_() / 2.0f), 0.0);
                Vec3 origin = this.m_20318_(1.0f).m_82520_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
                float distanceTo = (float)target.m_82554_(origin);
                target.m_82520_(0.0, (double)(distanceTo / 5.0f), 0.0);
                Vec3 direction = target.m_82546_(origin).m_82541_();
                toast.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 0.0f);
                this.getCapability(BrutalityCapabilities.SEAL_TYPE_CAP).ifPresent(toasterCap -> toast.getCapability(BrutalityCapabilities.SEAL_TYPE_CAP).ifPresent(toastCap -> toastCap.setSealType(toasterCap.getSealType())));
                toast.m_5602_((Entity)livingEntity);
                this.m_9236_().m_7967_((Entity)toast);
                this.m_216990_(SoundEvents.f_11796_);
                this.triggerAnim("controller", "shoot_" + this.lastAnim);
                this.lastAnim = 3 - this.lastAnim;
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> PlayState.CONTINUE).triggerableAnim("shoot_1", RawAnimation.begin().thenPlay("shoot_1")).triggerableAnim("shoot_2", RawAnimation.begin().thenPlay("shoot_2"))});
    }
}

