/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.spells.brimwielder;

import java.util.Random;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractArrow;
import net.goo.brutality.entity.explosion.BloodExplosion;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.magic.spells.brimwielder.AnnihilationSpell;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ModExplosionHelper;
import net.mcreator.terramity.init.TerramityModMobEffects;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AnnihilationEntity
extends BrutalityAbstractArrow
implements BrutalityGeoEntity,
IBrutalitySpellEntity {
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_DATA = SynchedEntityData.m_135353_(AnnihilationEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnnihilationEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected boolean m_142470_(@NotNull Player pPlayer) {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public float getSizeScaling() {
        return 0.0f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    public int getSpellLevel() {
        return (Integer)this.f_19804_.m_135370_(SPELL_LEVEL_DATA);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_LEVEL_DATA, (Object)1);
    }

    public SoundEvent m_36784_() {
        return SoundEvents.f_12515_;
    }

    @Override
    public void setSpellLevel(int spellLevel) {
        this.f_19804_.m_135381_(SPELL_LEVEL_DATA, (Object)spellLevel);
    }

    @Override
    public BrutalitySpell getSpell() {
        return new AnnihilationSpell();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("spell_level")) {
            this.setSpellLevel(tag.m_128451_("spell_level"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_level", this.getSpellLevel());
    }

    @Override
    public void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity entity;
        Entity entity2 = entityHitResult.m_82443_();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2) != this.m_19749_() && !entity.m_9236_().m_5776_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)TerramityModMobEffects.HEXED.get(), 60, 0));
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        Vec3 loc = pResult.m_82450_();
        long seed = Double.doubleToLongBits(loc.f_82479_) ^ Double.doubleToLongBits(loc.f_82480_) ^ Double.doubleToLongBits(loc.f_82481_);
        Random seeded = new Random(seed);
        if ((float)seeded.nextInt(0, 100) < this.getSpell().getFinalStat(this.getSpellLevel(), this.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.CHANCE))) {
            BloodExplosion explosion = new BloodExplosion(this.m_9236_(), this.m_19749_(), null, null, loc.f_82479_, loc.f_82480_, loc.f_82481_, 3.0f, false, Level.ExplosionInteraction.NONE);
            explosion.damageScale = (float)this.getSpellLevel() * 0.15f;
            explosion.setEntityFilter(e -> !(e instanceof AnnihilationEntity));
            ModExplosionHelper.Server.explode(explosion, this.m_9236_(), true);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_() && this.f_19797_ % 10 == 0 && !this.f_36703_) {
            this.m_9236_().m_7106_((ParticleOptions)TerramityModParticleTypes.STYGIAN_PARTICLE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.f_36704_ > 100) {
            this.m_146870_();
        }
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_12514_;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

