/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.spells.cosmic;

import java.util.List;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityAbstractArrow;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.magic.spells.cosmic.CosmicCataclysmSpell;
import net.goo.brutality.network.ClientboundParticlePacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.particle.providers.WaveParticleData;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CosmicCataclysmEntity
extends BrutalityAbstractArrow
implements BrutalityGeoEntity,
IBrutalitySpellEntity {
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_DATA = SynchedEntityData.m_135353_(CosmicCataclysmEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean shouldApplyWaveEffect = true;
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CosmicCataclysmEntity(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected boolean m_142470_(Player pPlayer) {
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public float getSizeScaling() {
        return 0.5f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    public int getSpellLevel() {
        return (Integer)this.f_19804_.m_135370_(SPELL_LEVEL_DATA);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_LEVEL_DATA, (Object)1);
    }

    @Override
    public void setSpellLevel(int spellLevel) {
        this.f_19804_.m_135381_(SPELL_LEVEL_DATA, (Object)spellLevel);
    }

    @Override
    public BrutalitySpell getSpell() {
        return new CosmicCataclysmSpell();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("spell_level")) {
            this.setSpellLevel(tag.m_128451_("spell_level"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_level", this.getSpellLevel());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_36704_ > 40) {
            this.m_146870_();
        }
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        super.m_6532_(hitResult);
        int spellLevel = this.getSpellLevel();
        BrutalitySpell spell = this.getSpell();
        float size = spell.getFinalStat(spellLevel, spell.getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE));
        WaveParticleData waveParticleData = new WaveParticleData((ParticleType)BrutalityModParticles.COSMIC_WAVE.get(), size * 2.0f, 50);
        Vec3 loc = hitResult.m_82450_();
        double x = loc.m_7096_();
        double y = loc.m_7098_();
        double z = loc.m_7094_();
        this.m_9236_().m_245747_(this.m_20097_(), (SoundEvent)BrutalityModSounds.METEOR_CRASH.get(), SoundSource.AMBIENT, (float)Math.min(spellLevel, 50), 1.5f - (float)spellLevel / 50.0f, false);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.m_19749_();
            if (level instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)level;
                PacketHandler.sendToNearbyClients(serverLevel, x, y, z, 128.0, new ClientboundParticlePacket(waveParticleData, true, (float)x, (float)y + 0.1f, (float)z, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1));
                if (this.shouldApplyWaveEffect) {
                    ModUtils.applyWaveEffect(serverLevel, (Entity)this, Entity.class, waveParticleData, e -> e != owner, e -> {
                        e.m_6469_(e.m_269291_().m_269515_(), spell.getFinalDamage((Entity)owner, spellLevel));
                        if (e instanceof Player) {
                            ((ServerPlayer)owner).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(e));
                        }
                    });
                }
            }
        }
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)((float)spellLevel / 2.0f + 3.0f)), e -> e instanceof LivingEntity && (!(e instanceof Player) || !e.m_5833_() && !((Player)e).m_7500_()));
        for (Entity entity : nearbyEntities) {
            if (entity == this || entity == this.m_19749_()) continue;
            Vec3 targetPos = entity.m_20318_(1.0f);
            Vec3 sourcePos = this.m_20318_(1.0f).m_82520_(0.0, -2.0, 0.0);
            Vec3 targetVector = targetPos.m_82546_(sourcePos).m_82541_();
            entity.m_246865_(targetVector.m_82490_((double)0.2f).m_82490_((double)(1 + spellLevel)));
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            }
            if (this.m_19749_() != null) {
                entity.m_6469_(entity.m_269291_().m_269104_(this.m_19749_(), null), this.getFinalDamage(spell, this.m_19749_(), spellLevel));
                continue;
            }
            entity.m_6469_(entity.m_269291_().m_269425_(), this.getFinalDamage(spell, this.m_19749_(), spellLevel));
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        this.m_20242_(true);
    }

    @Override
    public SoundEvent getHitEntitySoundEvent() {
        return SoundEvents.f_271165_;
    }

    public SoundEvent m_36784_() {
        return SoundEvents.f_271165_;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 0, this::predicate)});
    }

    private PlayState predicate(AnimationState<CosmicCataclysmEntity> state) {
        if (this.f_36703_) {
            state.setAndContinue(RawAnimation.begin().thenPlayAndHold("ground"));
        } else {
            state.setAndContinue(RawAnimation.begin().thenPlay("idle"));
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

