/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.entity.spells.umbrancy;

import com.google.common.collect.Lists;
import java.util.List;
import net.goo.brutality.client.entity.BrutalityGeoEntity;
import net.goo.brutality.entity.base.BrutalityShuriken;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpellEntity;
import net.goo.brutality.magic.spells.umbrancy.CrescentDartSpell;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrescentDart
extends BrutalityShuriken
implements BrutalityGeoEntity,
IBrutalitySpellEntity {
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_DATA = SynchedEntityData.m_135353_(CrescentDart.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<LivingEntity> piercedEntities = Lists.newArrayListWithCapacity((int)Mth.m_14143_((float)this.getSpell().getFinalStat(this.getSpellLevel(), this.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.PIERCE))));
    AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public CrescentDart(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.collideWithBlocks = false;
    }

    protected boolean m_142470_(@NotNull Player pPlayer) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public float getSizeScaling() {
        return 0.0f;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    public int getSpellLevel() {
        return (Integer)this.f_19804_.m_135370_(SPELL_LEVEL_DATA);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPELL_LEVEL_DATA, (Object)1);
    }

    @Override
    public void setSpellLevel(int spellLevel) {
        this.f_19804_.m_135381_(SPELL_LEVEL_DATA, (Object)spellLevel);
    }

    @Override
    public BrutalitySpell getSpell() {
        return new CrescentDartSpell();
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("spell_level")) {
            this.setSpellLevel(tag.m_128451_("spell_level"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("spell_level", this.getSpellLevel());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        BrutalitySpell spell = this.getSpell();
        int pierceCap = Mth.m_14143_((float)spell.getFinalStat(this.getSpellLevel(), spell.getStat(BrutalityTooltipHelper.SpellStatComponents.PIERCE)));
        int remainingCap = pierceCap - this.piercedEntities.size();
        if (remainingCap > 0) {
            LivingEntity nearest = this.m_9236_().m_45963_(LivingEntity.class, TargetingConditions.f_26872_.m_26888_(e -> !this.piercedEntities.contains(e)), null, this.m_20185_(), this.m_20186_(), this.m_20185_(), this.m_20191_().m_82400_(15.0));
            if (nearest == null) {
                if (pierceCap != remainingCap) {
                    this.m_146870_();
                }
            } else {
                Vec3 targetVec = nearest.m_20318_(1.0f).m_82520_(0.0, (double)(nearest.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20318_(1.0f));
                targetVec.m_82541_();
                this.m_20256_(targetVec.m_82490_((double)0.35f));
            }
        }
    }

    @Override
    protected void m_5790_(EntityHitResult pResult) {
        Entity entity = pResult.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            if (this.piercedEntities.contains(target)) {
                return;
            }
            this.piercedEntities.add(target);
            float dmg = this.getFinalDamage(this.getSpell(), this.m_19749_(), this.getSpellLevel());
            target.f_19802_ = 0;
            target.m_6469_(this.m_19749_() != null ? this.m_269291_().m_269104_(this.m_19749_(), null) : this.m_269291_().m_269425_(), dmg);
        }
        int pierceCap = Mth.m_14143_((float)this.getSpell().getFinalStat(this.getSpellLevel(), this.getSpell().getStat(BrutalityTooltipHelper.SpellStatComponents.PIERCE)));
        if (this.piercedEntities.size() + 1 > pierceCap) {
            this.m_146870_();
        }
    }

    @Override
    protected int getLifespan() {
        return 100;
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

