/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.entity.spells.cosmic.StarStreamEntity;
import net.goo.brutality.event.ConsumeManaEvent;
import net.goo.brutality.event.SpellCastEvent;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.event.forge.ForgePlayerStateHandler;
import net.goo.brutality.item.BrutalityArmorMaterials;
import net.goo.brutality.item.curios.charm.Sine;
import net.goo.brutality.item.curios.charm.Sum;
import net.goo.brutality.item.weapon.generic.CreaseOfCreation;
import net.goo.brutality.item.weapon.hammer.AtomicJudgementHammer;
import net.goo.brutality.item.weapon.hammer.TeratonHammer;
import net.goo.brutality.item.weapon.spear.EventHorizonSpear;
import net.goo.brutality.item.weapon.sword.SupernovaSword;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.magic.SpellCastingHandler;
import net.goo.brutality.magic.SpellCooldownTracker;
import net.goo.brutality.magic.spells.celestia.HolyMantleSpell;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.ModTags;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.SealUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnvironmentColorManager;
import net.mcreator.terramity.init.TerramityModMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="brutality")
public class LivingEntityEventHandler {
    @SubscribeEvent
    public static void onSpellCast(SpellCastEvent.Post event) {
        Player player = event.getPlayer();
        IBrutalitySpell spell = event.getSpell();
        int level = event.getSpellLevel();
        ItemStack tome = event.getStack();
        float manaCost = IBrutalitySpell.getActualManaCost(player, spell, level);
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            handler.findFirstCurio((Item)BrutalityModItems.HELLSPEC_TIE.get()).ifPresent(slotResult -> {
                if (spell.getSchool() == IBrutalitySpell.MagicSchool.BRIMWIELDER) {
                    SpellCastingHandler.addMana(player, manaCost * 0.25f);
                }
            });
            handler.findFirstCurio((Item)BrutalityModItems.SOUL_STONE.get()).ifPresent(slotResult -> {
                float chance = ModUtils.getSyncedSeededRandom((Entity)player).nextFloat(0.0f, 1.0f);
                if (chance < 0.05f) {
                    SpellCastingHandler.addMana(player, manaCost);
                } else {
                    SpellCastingHandler.addMana(player, manaCost * 0.15f);
                }
            });
        });
    }

    @SubscribeEvent
    public static void onConsumeMana(ConsumeManaEvent event) {
        float amount = event.getAmount();
        int level = event.getSpellLevel();
        IBrutalitySpell spell = event.getSpell();
        Player player = event.getPlayer();
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.ONYX_IDOL.get()).ifPresent(slot -> {
            ItemStack stack = slot.stack();
            CompoundTag tag = stack.m_41784_();
            tag.m_128350_("mana", tag.m_128457_("mana") + amount);
            if (tag.m_128457_("mana") > 200.0f) {
                SpellCooldownTracker.resetCooldowns(player);
                tag.m_128350_("mana", amount % 200.0f);
            }
        }));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player newPlayer = event.getEntity();
        ItemCooldowns newCooldowns = newPlayer.m_36335_();
        Item diamondBooster = (Item)BrutalityModItems.DIAMOND_BOOSTER_PACK.get();
        Item evilKingBooster = (Item)BrutalityModItems.EVIL_KING_BOOSTER_PACK.get();
        DelayedTaskScheduler.queueServerWork(event.getEntity().m_9236_(), 2, () -> newPlayer.getCapability(BrutalityCapabilities.RESPAWN_CAP).ifPresent(cap -> {
            int i;
            if (cap.getBoosterType() == EntityCapabilities.RespawnCap.BOOSTER_TYPE.EVIL_KING && !newCooldowns.m_41519_(evilKingBooster)) {
                newCooldowns.m_41524_(evilKingBooster, 18000);
                for (i = 0; i < 6; ++i) {
                    newPlayer.m_7292_(new MobEffectInstance(ForgePlayerStateHandler.boosterPackEffects.get().get(i), 6000, 1));
                }
            }
            if (cap.getBoosterType() == EntityCapabilities.RespawnCap.BOOSTER_TYPE.DIAMOND && !newCooldowns.m_41519_(diamondBooster)) {
                newCooldowns.m_41524_(diamondBooster, 36000);
                for (i = 0; i < 5; ++i) {
                    newPlayer.m_7292_(new MobEffectInstance(ForgePlayerStateHandler.boosterPackEffects.get().get(i), 2400, 1));
                }
            }
            if (cap.getBoosterType() == EntityCapabilities.RespawnCap.BOOSTER_TYPE.SILVER) {
                for (i = 0; i < 4; ++i) {
                    newPlayer.m_7292_(new MobEffectInstance(ForgePlayerStateHandler.boosterPackEffects.get().get(i), 600, 1));
                }
            }
            if (cap.getBoosterType() != EntityCapabilities.RespawnCap.BOOSTER_TYPE.NONE) {
                cap.setBoosterType(EntityCapabilities.RespawnCap.BOOSTER_TYPE.NONE);
            }
            if (cap.getKitType() != EntityCapabilities.RespawnCap.KIT_TYPE.NONE) {
                cap.setKitType(EntityCapabilities.RespawnCap.KIT_TYPE.NONE);
            }
        }));
    }

    @SubscribeEvent
    public static void entityVisibility(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity;
        if (ModUtils.hasFullArmorSet(event.getEntity(), BrutalityArmorMaterials.NOIR)) {
            event.modifyVisibility(0.0);
        }
        if ((livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            double visibility = player.m_21133_((Attribute)ModAttributes.ENTITY_VISIBILITY.get());
            event.modifyVisibility(visibility);
        }
    }

    @SubscribeEvent
    public static void onPlayerCrit(CriticalHitEvent event) {
        boolean crit;
        Player player = event.getEntity();
        boolean flag = (double)player.m_36403_(0.5f) > 0.9;
        float critChance = (float)player.m_21133_((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get());
        boolean bl = crit = player.m_217043_().m_188501_() < critChance - 1.0f;
        if (crit && flag) {
            event.setResult(Event.Result.ALLOW);
            event.setDamageModifier((float)event.getEntity().m_21133_((Attribute)ModAttributes.CRITICAL_STRIKE_DAMAGE.get()));
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                if (handler.isEquipped((Item)BrutalityModItems.FUZZY_DICE.get()) && player.m_217043_().m_188501_() < critChance - 1.0f) {
                    event.setDamageModifier(event.getDamageModifier() * 2.0f);
                }
            });
            if (event.getEntity().m_21023_((MobEffect)BrutalityModMobEffects.PRECISION.get())) {
                event.getEntity().m_21195_((MobEffect)BrutalityModMobEffects.PRECISION.get());
            }
        } else {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity healed = event.getEntity();
        CuriosApi.getCuriosInventory((LivingEntity)healed).ifPresent(handler -> {
            if (handler.isEquipped((Item)BrutalityModItems.HEMOMATIC_LOCKET.get())) {
                healed.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 0));
            }
        });
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getProjectile().m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            event.getProjectile().getCapability(BrutalityCapabilities.SEAL_TYPE_CAP).ifPresent(cap -> {
                Vec3 location;
                HitResult patt10400$temp = event.getRayTraceResult();
                if (patt10400$temp instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)patt10400$temp;
                    location = entityHitResult.m_82443_().m_20318_(1.0f).m_82520_(0.0, entityHitResult.m_82443_().m_20227_(0.5), 0.0);
                } else {
                    location = event.getRayTraceResult().m_82450_();
                }
                SealUtils.handleSealProc(owner.m_9236_(), owner, location, cap.getSealType());
            });
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        AttributeInstance attributeInstance;
        Player attackerPlayer;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        Level level = victim.m_9236_();
        float[] modifiedAmount = new float[]{event.getAmount()};
        victim.m_6168_().forEach(stack -> {
            SealUtils.SEAL_TYPE sealType = SealUtils.getSealType(stack);
            RandomSource random = level.m_213780_();
            if (sealType != null) {
                switch (sealType) {
                    case BOMB: {
                        level.m_254849_((Entity)victim, victim.m_20208_(2.0), victim.m_20227_(0.5), victim.m_20246_(2.0), 2.0f, Level.ExplosionInteraction.NONE);
                        break;
                    }
                    case COSMIC: {
                        StarStreamEntity spellEntity = new StarStreamEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.STAR_STREAM_ENTITY.get()), level);
                        spellEntity.setSpellLevel(0);
                        Vec3 randomPos = attacker == null ? new Vec3(victim.m_20208_(2.0), victim.m_20227_(0.5) + (double)Mth.m_216267_((RandomSource)random, (float)7.5f, (float)12.5f), victim.m_20262_(2.0)) : new Vec3(attacker.m_20208_(2.0), attacker.m_20227_(0.5) + (double)Mth.m_216267_((RandomSource)random, (float)7.5f, (float)12.5f), attacker.m_20262_(2.0));
                        spellEntity.m_146884_(randomPos);
                        spellEntity.m_5602_((Entity)victim);
                        Vec3 targetPos = attacker == null ? new Vec3(victim.m_20208_(10.0), victim.m_20186_(), victim.m_20262_(10.0)) : attacker.m_20318_(1.0f).m_82520_(0.0, (double)attacker.m_20206_() * 0.5, 0.0);
                        Vec3 direction = targetPos.m_82546_(randomPos).m_82541_();
                        spellEntity.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 1.5f);
                        level.m_7967_((Entity)spellEntity);
                        level.m_6263_(null, victim.m_20185_(), victim.m_20227_(0.5), victim.m_20189_(), (SoundEvent)BrutalityModSounds.BASS_BOP.get(), SoundSource.AMBIENT, 1.5f, Mth.m_216267_((RandomSource)random, (float)0.7f, (float)1.2f));
                    }
                }
            }
        });
        if (attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (attacker instanceof Player) {
                Player playerAttacker = (Player)attacker;
                AttributeInstance omnivampAttr = playerAttacker.m_21051_((Attribute)ModAttributes.OMNIVAMP.get());
                if (omnivampAttr != null) {
                    playerAttacker.m_5634_((float)((double)modifiedAmount[0] * (omnivampAttr.m_22135_() - 1.0)));
                }
                playerAttacker.getCapability(BrutalityCapabilities.PLAYER_COMBO_CAP).ifPresent(cap -> {
                    if (cap.lastVictimId() == victim.m_19879_() && System.currentTimeMillis() - cap.lastHitTime() < 5000L) {
                        cap.setHitCount((cap.hitCount() + 1) % 15);
                    } else {
                        cap.setHitCount(1);
                    }
                    cap.setLastVictimId(victim.m_19879_());
                    cap.setLastHitTime(System.currentTimeMillis());
                    PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(playerAttacker.m_19879_(), (Entity)playerAttacker));
                    CuriosApi.getCuriosInventory((LivingEntity)playerAttacker).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.EXPONENTIAL_CHARM.get()).ifPresent(slot -> {
                        modifiedAmount[0] = (float)Math.pow(modifiedAmount[0], 0.01 * (double)cap.hitCount() + 1.0);
                    }));
                });
            }
            CuriosApi.getCuriosInventory((LivingEntity)livingAttacker).ifPresent(handler -> {
                LivingEntity nearestEntity;
                if (handler.isEquipped((Item)BrutalityModItems.CROWBAR.get()) && victim.m_21223_() / victim.m_21233_() > 0.9f) {
                    modifiedAmount[0] = modifiedAmount[0] * 1.4f;
                }
                if (handler.isEquipped((Item)BrutalityModItems.DUELING_GLOVE.get()) && (nearestEntity = level.m_45963_(LivingEntity.class, TargetingConditions.f_26872_, livingAttacker, livingAttacker.m_20185_(), livingAttacker.m_20186_(), livingAttacker.m_20189_(), livingAttacker.m_20191_().m_82400_(100.0))) == victim) {
                    modifiedAmount[0] = modifiedAmount[0] * 1.5f;
                }
                if (handler.isEquipped((Item)BrutalityModItems.OLD_GUILLOTINE.get()) && victim.m_21223_() <= 5.0f) {
                    victim.m_6074_();
                    return;
                }
                if (handler.isEquipped((Item)BrutalityModItems.BLOOD_PULSE_GAUNTLETS.get()) && livingAttacker.m_21023_((MobEffect)BrutalityModMobEffects.ENRAGED.get())) {
                    livingAttacker.m_9236_().m_254951_((Entity)livingAttacker, livingAttacker.m_269291_().m_269036_((Entity)livingAttacker, null), null, victim.m_20182_(), 0.25f, false, Level.ExplosionInteraction.MOB);
                }
                if (handler.isEquipped((Item)BrutalityModItems.THE_OATH.get())) {
                    victim.f_19802_ = 0;
                    victim.m_6469_(victim.m_269291_().m_269104_((Entity)livingAttacker, null), modifiedAmount[0] * 0.1f);
                }
                handler.findFirstCurio((Item)BrutalityModItems.SUM_CHARM.get()).ifPresent(slot -> {
                    float damageStored = slot.stack().m_41784_().m_128457_(Sum.SUM_DAMAGE);
                    modifiedAmount[0] = modifiedAmount[0] + damageStored;
                    slot.stack().m_41784_().m_128350_(Sum.SUM_DAMAGE, 0.0f);
                });
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (handler.isEquipped((Item)BrutalityModItems.SINE_CHARM.get())) {
                        modifiedAmount[0] = modifiedAmount[0] + Sine.getCurrentBonus((Level)serverLevel);
                    }
                }
                handler.findFirstCurio((Item)BrutalityModItems.GLUTTONY_CHARM.get()).ifPresent(slot -> {
                    modifiedAmount[0] = modifiedAmount[0] + (float)slot.stack().m_41784_().m_128451_("souls") * 0.01f;
                });
                if (handler.isEquipped((Item)BrutalityModItems.CROWN_OF_TYRANNY.get())) {
                    float missingHealthRatio = victim.m_21223_() / victim.m_21233_();
                    modifiedAmount[0] = modifiedAmount[0] * ((1.0f + (1.0f - missingHealthRatio)) * 0.75f);
                }
                if (handler.isEquipped((Item)BrutalityModItems.PORTABLE_QUANTUM_THINGAMABOB.get())) {
                    livingAttacker.m_7292_(new MobEffectInstance((MobEffect)TerramityModMobEffects.MIRRORING.get(), 20));
                }
                int[] fridgeMult = new int[]{1};
                handler.findFirstCurio((Item)BrutalityModItems.FRIDGE_CHARM.get()).ifPresent(slot -> {
                    fridgeMult[0] = 2;
                });
                handler.findFirstCurio((Item)BrutalityModItems.SMART_FRIDGE_CHARM.get()).ifPresent(slot -> {
                    fridgeMult[0] = 3;
                });
                handler.findFirstCurio((Item)BrutalityModItems.PIZZA_SLOP_CHARM.get()).ifPresent(slot -> victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SLICKED.get(), 120 * fridgeMult[0], 1, false, false)));
                handler.findFirstCurio((Item)BrutalityModItems.THE_SMOKEHOUSE.get()).ifPresent(slot -> victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SMOKED.get(), 80 * fridgeMult[0], 1, false, false)));
                handler.findFirstCurio((Item)BrutalityModItems.EXTRA_VIRGIN_OLIVE_OIL_CHARM.get()).ifPresent(slot -> victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.OILED.get(), 120 * fridgeMult[0], 3)));
                handler.findFirstCurio((Item)BrutalityModItems.CARAMEL_CRUNCH_MEDALLION.get()).ifPresent(slot -> {
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.CANDIED.get(), 80 * fridgeMult[0], 1));
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.CARAMELIZED.get(), 80 * fridgeMult[0], 1));
                });
                handler.findFirstCurio((Item)BrutalityModItems.DUNKED_DONUT.get()).ifPresent(slot -> {
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.GLAZED.get(), 80 * fridgeMult[0], 1));
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SPRINKLED.get(), 80 * fridgeMult[0], 1));
                });
                handler.findFirstCurio((Item)BrutalityModItems.LOLLIPOP_OF_ETERNITY.get()).ifPresent(slot -> {
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.GLAZED.get(), 120 * fridgeMult[0], 2));
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.CARAMELIZED.get(), 120 * fridgeMult[0], 2));
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SPRINKLED.get(), 120 * fridgeMult[0], 2));
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.CANDIED.get(), 120 * fridgeMult[0], 2));
                });
                handler.findFirstCurio((Item)BrutalityModItems.SALT_AND_PEPPER_CHARM.get()).ifPresent(slot -> {
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.SALTED.get(), 120 * fridgeMult[0], 1));
                    victim.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.PEPPERED.get(), 120 * fridgeMult[0], 1));
                });
            });
            if (victim.m_21023_((MobEffect)BrutalityModMobEffects.STONEFORM.get())) {
                int amp = Objects.requireNonNull(victim.m_21124_((MobEffect)BrutalityModMobEffects.STONEFORM.get())).m_19564_();
                modifiedAmount[0] = modifiedAmount[0] * (1.0f - 0.1f * ((float)amp + 1.0f));
            }
            CuriosApi.getCuriosInventory((LivingEntity)victim).ifPresent(handler -> {
                handler.findFirstCurio((Item)BrutalityModItems.YATA_NO_KAGAMI.get()).ifPresent(slot -> {
                    float negated = modifiedAmount[0] * 0.25f;
                    modifiedAmount[0] = Math.max(0.0f, modifiedAmount[0] - negated);
                    livingAttacker.m_6469_(livingAttacker.m_269291_().m_269104_((Entity)victim, null), negated);
                });
                handler.findFirstCurio((Item)BrutalityModItems.BLOODSTAINED_MIRROR.get()).ifPresent(slot -> livingAttacker.m_6469_(livingAttacker.m_269291_().m_269104_((Entity)victim, null), modifiedAmount[0] * 0.1f));
                handler.findFirstCurio((Item)BrutalityModItems.DUELING_GLOVE.get()).ifPresent(slot -> {
                    List nearbyEntities = level.m_6443_(LivingEntity.class, victim.m_20191_().m_82400_(100.0), e -> e != victim && !(e instanceof ArmorStand));
                    LivingEntity nearestEntity = nearbyEntities.stream().min(Comparator.comparingDouble(e -> e.m_20280_((Entity)victim))).orElse(null);
                    if (nearestEntity != livingAttacker) {
                        modifiedAmount[0] = modifiedAmount[0] * 1.5f;
                    }
                });
            });
            CuriosApi.getCuriosInventory((LivingEntity)livingAttacker).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.GREED_CHARM.get()).ifPresent(slot -> {
                modifiedAmount[0] = modifiedAmount[0] * (1.0f + (float)slot.stack().m_41784_().m_128451_("greed_bonus") * 0.01f);
            }));
        }
        if (victim.m_21023_((MobEffect)BrutalityModMobEffects.GRACE.get()) && modifiedAmount[0] <= (float)victim.m_21124_((MobEffect)BrutalityModMobEffects.GRACE.get()).m_19564_() * BrutalitySpell.getStat(HolyMantleSpell.class, BrutalityTooltipHelper.SpellStatComponents.DEFENSE).levelDelta()) {
            event.setCanceled(true);
            victim.m_21195_((MobEffect)BrutalityModMobEffects.GRACE.get());
            return;
        }
        Entity amp = event.getSource().m_7639_();
        if (amp instanceof Player && !(attackerPlayer = (Player)amp).m_21023_((MobEffect)BrutalityModMobEffects.ENRAGED.get())) {
            CuriosApi.getCuriosInventory((LivingEntity)attackerPlayer).ifPresent(handler -> {
                if (!handler.findCurios(stack -> stack.m_204117_(ModTags.Items.RAGE_ITEMS)).isEmpty()) {
                    attackerPlayer.getCapability(BrutalityCapabilities.PLAYER_RAGE_CAP).ifPresent(cap -> {
                        float damageDealt = modifiedAmount[0];
                        float rageGain = damageDealt / 5.0f;
                        AttributeInstance rageGainAttr = attackerPlayer.m_21051_((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get());
                        if (rageGainAttr != null) {
                            rageGain *= (float)rageGainAttr.m_22135_();
                        }
                        cap.incrementRage(Math.max(0.0f, rageGain));
                        LivingEntityEventHandler.tryTriggerRage(attackerPlayer, handler, cap);
                    });
                }
            });
        }
        if (victim instanceof Player) {
            int foodLevel;
            Player victimPlayer = (Player)victim;
            if (victimPlayer.m_21023_((MobEffect)BrutalityModMobEffects.SAD.get()) && (foodLevel = victimPlayer.m_36324_().m_38702_()) > 0) {
                float foodReduction = modifiedAmount[0] / 2.0f;
                victimPlayer.m_36324_().m_38705_((int)Math.max(0.0f, (float)foodLevel - foodReduction));
                modifiedAmount[0] = foodReduction;
            }
            CuriosApi.getCuriosInventory((LivingEntity)victimPlayer).ifPresent(handler -> {
                handler.findFirstCurio((Item)BrutalityModItems.HEART_OF_GOLD.get()).ifPresent(slot -> {
                    if (victimPlayer.m_6103_() == 0.0f) {
                        DelayedTaskScheduler.queueServerWork(level, 1, () -> victimPlayer.m_7911_(victimPlayer.m_6103_() + modifiedAmount[0] / 2.0f));
                    }
                });
                handler.findFirstCurio((Item)BrutalityModItems.NANOMACHINES.get()).ifPresent(slot -> {
                    DamageSource source = event.getSource();
                    if (source.m_269533_(DamageTypeTags.f_268490_)) {
                        return;
                    }
                    if (source.m_269533_(DamageTypeTags.f_268524_) || source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268511_)) {
                        modifiedAmount[0] = Math.max(0.0f, modifiedAmount[0] / 2.0f);
                    }
                });
                if (handler.isEquipped((Item)BrutalityModItems.SUBTRACTION_CHARM.get())) {
                    modifiedAmount[0] = Math.max(0.0f, modifiedAmount[0] - 2.0f);
                }
                if (handler.isEquipped((Item)BrutalityModItems.DIVISION_CHARM.get())) {
                    modifiedAmount[0] = Math.max(0.0f, modifiedAmount[0] / 1.1f);
                }
                handler.findFirstCurio((Item)BrutalityModItems.SUM_CHARM.get()).ifPresent(slot -> {
                    float damageStored = slot.stack().m_41784_().m_128457_(Sum.SUM_DAMAGE);
                    slot.stack().m_41784_().m_128350_(Sum.SUM_DAMAGE, Math.min(150.0f, damageStored + Math.min(10.0f, modifiedAmount[0] / 2.0f)));
                });
                if (handler.isEquipped((Item)BrutalityModItems.BLOOD_ORB.get())) {
                    SpellCastingHandler.addMana(victimPlayer, modifiedAmount[0] * 7.5f);
                }
                if (!victimPlayer.m_21023_((MobEffect)BrutalityModMobEffects.ENRAGED.get()) && !handler.findCurios(stack -> stack.m_204117_(ModTags.Items.RAGE_ITEMS)).isEmpty()) {
                    victimPlayer.getCapability(BrutalityCapabilities.PLAYER_RAGE_CAP).ifPresent(cap -> {
                        float rageGain = modifiedAmount[0];
                        AttributeInstance rageGainAttr = victimPlayer.m_21051_((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get());
                        if (rageGainAttr != null) {
                            rageGain *= (float)rageGainAttr.m_22135_();
                        }
                        cap.incrementRage(Math.max(0.0f, rageGain));
                        LivingEntityEventHandler.tryTriggerRage(victimPlayer, handler, cap);
                    });
                }
            });
        }
        if ((attributeInstance = victim.m_21051_((Attribute)ModAttributes.DAMAGE_TAKEN.get())) != null) {
            modifiedAmount[0] = (float)((double)modifiedAmount[0] * attributeInstance.m_22135_());
        }
        event.setAmount(Math.max(0.0f, modifiedAmount[0]));
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        LivingEntity victim = event.getEntity();
        LivingEntity lastAttacker = victim.m_271686_();
        if (lastAttacker instanceof Player) {
            Player player = (Player)lastAttacker;
            Item item = player.m_21205_().m_41720_();
            if (item instanceof TeratonHammer) {
                float kbMult = (float)Math.pow(player.m_36403_(0.5f), 3.0);
                event.setStrength(event.getOriginalStrength() * 10.0f * kbMult);
            }
            if (item instanceof EventHorizonSpear) {
                event.setCanceled(true);
                Vec3 direction = lastAttacker.m_20318_(1.0f).m_82546_(victim.m_20318_(1.0f)).m_82541_();
                victim.m_246865_(direction.m_82490_(1.2));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> {
                handler.findFirstCurio((Item)BrutalityModItems.CELESTIAL_STARBOARD.get()).ifPresent(slotResult -> event.setCanceled(true));
                handler.findFirstCurio((Item)BrutalityModItems.HYPERBOLIC_FEATHER.get()).ifPresent(slotResult -> {
                    if (!player.m_36335_().m_41519_(slotResult.stack().m_41720_())) {
                        player.m_36335_().m_41524_(slotResult.stack().m_41720_(), 80);
                        DelayedTaskScheduler.queueServerWork(event.getEntity().m_9236_(), 1, () -> player.m_5634_((float)(2 * ModUtils.calculateFallDamage((LivingEntity)player, event.getDistance(), event.getDamageMultiplier()))));
                    }
                });
                handler.findFirstCurio((Item)BrutalityModItems.TOPAZ_ANKLET.get()).ifPresent(slotResult -> {
                    Vec3 loc = entity.m_20318_(1.0f);
                    long gameTime = entity.m_9236_().m_46467_();
                    long seed = Double.doubleToLongBits(loc.f_82479_) ^ Double.doubleToLongBits(loc.f_82480_) ^ Double.doubleToLongBits(loc.f_82481_) ^ gameTime;
                    Random seeded = new Random(seed);
                    float chance = seeded.nextFloat(0.0f, 1.0f);
                    if (chance < 0.9f) {
                        event.setCanceled(true);
                    }
                });
            });
            if (player.m_21205_().m_41720_() instanceof AtomicJudgementHammer) {
                event.setDamageMultiplier(0.15f);
                if (event.getDistance() > 10.0f && !player.m_9236_().m_5776_() && player.m_6144_()) {
                    AtomicJudgementHammer.doExplosion(player, player.m_20318_(1.0f));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity victim = event.getEntity();
        Level level = victim.m_9236_();
        level.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, victim, victim.m_20191_().m_82400_(3.0)).forEach(nearbyEntity -> CuriosApi.getCuriosInventory((LivingEntity)nearbyEntity).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.SELF_REPAIR_NEXUS.get()).ifPresent(slot -> nearbyEntity.m_5634_(2.0f))));
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player attackerPlayer = (Player)entity;
            CuriosApi.getCuriosInventory((LivingEntity)attackerPlayer).ifPresent(handler -> {
                handler.findFirstCurio((Item)BrutalityModItems.GLUTTONY_CHARM.get()).ifPresent(slot -> {
                    ItemStack stack = slot.stack();
                    CompoundTag tag = stack.m_41784_();
                    int souls = tag.m_128451_("souls") + 1;
                    tag.m_128405_("souls", souls);
                });
                handler.findFirstCurio((Item)BrutalityModItems.RAMPAGE_CLOCK.get()).ifPresent(slot -> ModUtils.modifyEffect((LivingEntity)attackerPlayer, (MobEffect)BrutalityModMobEffects.ENRAGED.get(), new ModUtils.ModValue(20, false), null, null, null, null));
            });
        }
        if ((entity = event.getEntity()) instanceof Player) {
            Player victimPlayer = (Player)entity;
            Level level2 = victimPlayer.m_9236_();
            if (level2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level2;
                SupernovaSword.clearAsteroids(victimPlayer, serverLevel);
                CreaseOfCreation.handleCreaseOfCreation(victimPlayer);
            }
            EnvironmentColorManager.resetAllColors();
            if (victimPlayer.m_21023_((MobEffect)BrutalityModMobEffects.ENRAGED.get())) {
                CuriosApi.getCuriosInventory((LivingEntity)victimPlayer).ifPresent(handler -> handler.findFirstCurio((Item)BrutalityModItems.GRUDGE_TOTEM.get()).ifPresent(slot -> {
                    event.setCanceled(true);
                    victimPlayer.m_21153_(0.5f);
                }));
            }
            CuriosApi.getCuriosInventory((LivingEntity)victimPlayer).ifPresent(handler -> {
                ItemCooldowns cooldowns = victimPlayer.m_36335_();
                victimPlayer.getCapability(BrutalityCapabilities.RESPAWN_CAP).ifPresent(cap -> {
                    if (handler.isEquipped((Item)BrutalityModItems.SILVER_BOOSTER_PACK.get())) {
                        cap.setBoosterType(EntityCapabilities.RespawnCap.BOOSTER_TYPE.SILVER);
                    }
                    if (handler.isEquipped((Item)BrutalityModItems.DIAMOND_BOOSTER_PACK.get()) && !cooldowns.m_41519_((Item)BrutalityModItems.DIAMOND_BOOSTER_PACK.get())) {
                        cap.setBoosterType(EntityCapabilities.RespawnCap.BOOSTER_TYPE.DIAMOND);
                    }
                    if (handler.isEquipped((Item)BrutalityModItems.EVIL_KING_BOOSTER_PACK.get()) && !cooldowns.m_41519_((Item)BrutalityModItems.EVIL_KING_BOOSTER_PACK.get())) {
                        cap.setBoosterType(EntityCapabilities.RespawnCap.BOOSTER_TYPE.EVIL_KING);
                    }
                });
                if (handler.isEquipped((Item)BrutalityModItems.EVIL_KING_RESPAWN_CARD.get()) && !cooldowns.m_41519_((Item)BrutalityModItems.EVIL_KING_RESPAWN_CARD.get())) {
                    cooldowns.m_41524_((Item)BrutalityModItems.EVIL_KING_RESPAWN_CARD.get(), 18000);
                    event.setCanceled(true);
                    victimPlayer.m_21153_(6.0f);
                } else if (handler.isEquipped((Item)BrutalityModItems.DIAMOND_RESPAWN_CARD.get()) && !cooldowns.m_41519_((Item)BrutalityModItems.DIAMOND_RESPAWN_CARD.get())) {
                    cooldowns.m_41524_((Item)BrutalityModItems.DIAMOND_RESPAWN_CARD.get(), 36000);
                    event.setCanceled(true);
                    victimPlayer.m_21153_(4.0f);
                } else {
                    handler.findFirstCurio((Item)BrutalityModItems.SILVER_RESPAWN_CARD.get()).ifPresent(slot -> {
                        slot.stack().m_41622_(slot.stack().m_41776_(), (LivingEntity)victimPlayer, player -> {});
                        event.setCanceled(true);
                        victimPlayer.m_21153_(2.0f);
                    });
                }
            });
        }
    }

    public static void tryTriggerRage(Player player, ICuriosItemHandler handler, EntityCapabilities.PlayerRageCap cap) {
        int maxRage = (int)player.m_21133_((Attribute)ModAttributes.MAX_RAGE.get());
        if (cap.rageValue() >= (float)maxRage && handler.findFirstCurio((Item)BrutalityModItems.ANGER_MANAGEMENT.get()).isEmpty()) {
            AttributeInstance rageLevelAttr;
            int duration = 40;
            int rageLevel = (int)Math.floor(cap.rageValue() / 100.0f);
            AttributeInstance rageTimeAttr = player.m_21051_((Attribute)ModAttributes.RAGE_TIME_MULTIPLIER.get());
            if (rageTimeAttr != null) {
                duration = (int)((double)duration * rageTimeAttr.m_22135_());
            }
            if ((rageLevelAttr = player.m_21051_((Attribute)ModAttributes.RAGE_LEVEL.get())) != null) {
                rageLevel += (int)rageLevelAttr.m_22135_();
            }
            player.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.ENRAGED.get(), duration, rageLevel, false, true));
            cap.setRageValue(0.0f);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        cap.setRageValue(Math.min(cap.rageValue(), (float)maxRage));
        PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
    }
}

