/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.event.forge;

import com.google.common.base.Suppliers;
import com.lowdragmc.photon.client.fx.EntityEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.item.BrutalityArmorMaterials;
import net.goo.brutality.item.weapon.axe.RhittaAxe;
import net.goo.brutality.item.weapon.generic.CreaseOfCreation;
import net.goo.brutality.item.weapon.spear.EventHorizonSpear;
import net.goo.brutality.item.weapon.sword.BladeOfTheRuinedKingSword;
import net.goo.brutality.item.weapon.sword.DullKnifeSword;
import net.goo.brutality.item.weapon.sword.SupernovaSword;
import net.goo.brutality.item.weapon.tome.BaseMagicTome;
import net.goo.brutality.item.weapon.trident.ThunderboltTrident;
import net.goo.brutality.mob_effect.TheVoidEffect;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.ClientboundSyncItemCooldownPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.ModResources;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.EnvironmentColorManager;
import net.mcreator.terramity.init.TerramityModMobEffects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingSwapItemsEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import oshi.util.tuples.Pair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgePlayerStateHandler {
    public static final Supplier<List<Item>> cdPersistItems = Suppliers.memoize(() -> List.of((Item)BrutalityModItems.EVIL_KING_BOOSTER_PACK.get(), (Item)BrutalityModItems.EVIL_KING_RESPAWN_CARD.get(), (Item)BrutalityModItems.DIAMOND_BOOSTER_PACK.get(), (Item)BrutalityModItems.DIAMOND_RESPAWN_CARD.get(), (Item)BrutalityModItems.SILVER_BOOSTER_PACK.get(), (Item)BrutalityModItems.SILVER_RESPAWN_CARD.get()));
    public static final Supplier<List<MobEffect>> boosterPackEffects = Suppliers.memoize(() -> List.of(MobEffects.f_19618_, MobEffects.f_19596_, MobEffects.f_19617_, MobEffects.f_19603_, MobEffects.f_19606_, (MobEffect)TerramityModMobEffects.IMMUNITY.get()));
    private static final List<Pair<Predicate<ItemStack>, HoldToggleAction>> TOGGLE_ACTIONS = new ArrayList<Pair<Predicate<ItemStack>, HoldToggleAction>>();

    @SubscribeEvent
    public static void onSwitchItemHands(LivingSwapItemsEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21055_((Item)BrutalityModItems.LAST_PRISM_ITEM.get()) && player.m_6117_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onAddEffect(MobEffectEvent.Added event) {
        LivingEntity entity = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        MobEffect effect = instance.m_19544_();
        if (!entity.m_9236_().f_46443_ && effect instanceof TheVoidEffect && entity instanceof Player) {
            Player player = (Player)entity;
            PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
        }
    }

    @SubscribeEvent
    public static void onChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SupernovaSword.clearAsteroids(player, serverLevel);
            CreaseOfCreation.handleCreaseOfCreation(player);
        }
        EnvironmentColorManager.resetAllColors();
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player newPlayer = event.getEntity();
        Player oldPlayer = event.getOriginal();
        if (event.isWasDeath()) {
            ItemCooldowns newCooldowns = newPlayer.m_36335_();
            ItemCooldowns oldCooldowns = oldPlayer.m_36335_();
            boolean shouldSync = false;
            for (Map.Entry entry : oldCooldowns.f_41515_.entrySet()) {
                Item item = (Item)entry.getKey();
                if (!cdPersistItems.get().contains(item)) continue;
                ItemCooldowns.CooldownInstance cooldown = (ItemCooldowns.CooldownInstance)entry.getValue();
                newCooldowns.f_41515_.put(item, new ItemCooldowns.CooldownInstance(cooldown.f_41533_, cooldown.f_41534_));
                newCooldowns.f_41516_ = oldCooldowns.f_41516_;
                shouldSync = true;
            }
            if (shouldSync) {
                DelayedTaskScheduler.queueServerWork(newPlayer.m_9236_(), 1, () -> PacketHandler.sendToPlayer(new ClientboundSyncItemCooldownPacket(newCooldowns.f_41515_, newCooldowns.f_41516_), (ServerPlayer)newPlayer));
            }
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SupernovaSword.clearAsteroids((Player)player2, player2.m_284548_());
            CreaseOfCreation.handleCreaseOfCreation((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ItemCooldowns itemCooldowns = player2.m_36335_();
            PacketHandler.sendToPlayer(new ClientboundSyncItemCooldownPacket(itemCooldowns.f_41515_, itemCooldowns.f_41516_), player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerContainerOpen(PlayerContainerEvent.Open event) {
        final Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        AbstractContainerMenu menu = event.getContainer();
        final HashMap<Integer, ItemStack> initialContents = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < menu.f_38839_.size(); ++i) {
            Slot slot = menu.m_38853_(i);
            if (slot.f_40218_ != player.m_150109_()) continue;
            initialContents.put(i, slot.m_7993_().m_41777_());
        }
        menu.m_38893_(new ContainerListener(){

            public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack newStack) {
                int newCount;
                if (!initialContents.containsKey(slotIndex)) {
                    return;
                }
                ItemStack oldStack = (ItemStack)initialContents.get(slotIndex);
                int oldCount = oldStack.m_41613_();
                if (oldCount > (newCount = newStack.m_41613_()) && ForgePlayerStateHandler.isSpecificItem(oldStack)) {
                    ForgePlayerStateHandler.triggerItemLeftInventory(player, oldStack);
                }
                initialContents.put(slotIndex, newStack.m_41777_());
            }

            public void m_142153_(AbstractContainerMenu menu, int slotIndex, int data) {
            }
        });
    }

    @SubscribeEvent
    public static void onItemPutInFrame(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() instanceof ItemFrame && ForgePlayerStateHandler.isSpecificItem(event.getItemStack())) {
            ForgePlayerStateHandler.triggerItemLeftInventory(event.getEntity(), event.getItemStack());
        }
    }

    private static boolean isSpecificItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        Item item = stack.m_41720_();
        return item instanceof EventHorizonSpear || item instanceof RhittaAxe || item instanceof BaseMagicTome;
    }

    private static void triggerItemLeftInventory(Player player, ItemStack oldStack) {
        Item item = oldStack.m_41720_();
        if (item instanceof EventHorizonSpear) {
            EventHorizonSpear lance = (EventHorizonSpear)item;
            lance.despawnBlackHole(player, oldStack);
        } else if (item instanceof RhittaAxe) {
            RhittaAxe axe = (RhittaAxe)item;
            axe.despawnCruelSun(player, oldStack);
        } else if (item instanceof BaseMagicTome) {
            BaseMagicTome tome = (BaseMagicTome)item;
            tome.tryCloseBook(player, oldStack);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            for (Pair<Predicate<ItemStack>, HoldToggleAction> entry : TOGGLE_ACTIONS) {
                Predicate matcher = (Predicate)entry.getA();
                HoldToggleAction action = (HoldToggleAction)entry.getB();
                boolean isHolding = matcher.test(player.m_21205_()) || matcher.test(player.m_21206_());
                String tagKey = "holding_action_" + TOGGLE_ACTIONS.indexOf(entry);
                boolean wasHolding = player.getPersistentData().m_128471_(tagKey);
                if (isHolding && !wasHolding) {
                    action.onHold().run(player);
                    player.getPersistentData().m_128379_(tagKey, true);
                    continue;
                }
                if (isHolding || !wasHolding) continue;
                action.onRelease().run(player);
                player.getPersistentData().m_128379_(tagKey, false);
            }
            if (ModUtils.hasFullArmorSet((LivingEntity)player, BrutalityArmorMaterials.TERRA)) {
                if (player.m_6047_()) {
                    if (!player.m_21023_((MobEffect)BrutalityModMobEffects.STONEFORM.get())) {
                        player.m_216990_(SoundEvents.f_12447_);
                    }
                    player.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.STONEFORM.get(), 20, 0, false, true));
                } else if (player.m_21023_((MobEffect)BrutalityModMobEffects.STONEFORM.get())) {
                    player.m_21195_((MobEffect)BrutalityModMobEffects.STONEFORM.get());
                }
            }
            player.getCapability(BrutalityCapabilities.PLAYER_MANA_CAP).ifPresent(cap -> {
                AttributeInstance maxManaAttr = player.m_21051_((Attribute)ModAttributes.MAX_MANA.get());
                AttributeInstance manaRegenAttr = player.m_21051_((Attribute)ModAttributes.MANA_REGEN.get());
                if (maxManaAttr != null && manaRegenAttr != null) {
                    if ((double)cap.manaValue() <= maxManaAttr.m_22135_()) {
                        ICuriosItemHandler handler;
                        float additionalBonus = 0.0f;
                        if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent() && (handler = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).orElse(null)).isEquipped((Item)BrutalityModItems.FORBIDDEN_ORB.get()) && (double)cap.manaValue() <= maxManaAttr.m_22135_() * (double)0.3f) {
                            player.m_6074_();
                            return;
                        }
                        cap.incrementMana((float)((manaRegenAttr.m_22135_() + (double)additionalBonus) / 20.0));
                    }
                    cap.setManaValue((float)Mth.m_14008_((double)cap.manaValue(), (double)0.0, (double)maxManaAttr.m_22135_()));
                }
            });
        }
    }

    static {
        TOGGLE_ACTIONS.add((Pair<Predicate<ItemStack>, HoldToggleAction>)new Pair(stack -> stack.m_41720_() instanceof CreaseOfCreation, (Object)new HoldToggleAction(player -> {
            if (!(player.m_9236_() instanceof ServerLevel)) {
                EntityEffect effect = new EntityEffect(ModResources.CREASE_OF_CREATION_FX, player.m_9236_(), (Entity)player, EntityEffect.AutoRotate.NONE);
                effect.start();
            }
        }, player -> {
            if (!(player.m_9236_() instanceof ServerLevel)) {
                ModUtils.removeFX((Entity)player, ModResources.CREASE_OF_CREATION_FX);
            }
        })));
        TOGGLE_ACTIONS.add((Pair<Predicate<ItemStack>, HoldToggleAction>)new Pair(stack -> stack.m_41720_() instanceof BladeOfTheRuinedKingSword, (Object)new HoldToggleAction(player -> {
            if (!(player.m_9236_() instanceof ServerLevel)) {
                EntityEffect effect = new EntityEffect(ModResources.RUINED_AURA_FX, player.m_9236_(), (Entity)player, EntityEffect.AutoRotate.NONE);
                effect.start();
            }
        }, player -> {
            if (!(player.m_9236_() instanceof ServerLevel)) {
                ModUtils.removeFX((Entity)player, ModResources.RUINED_AURA_FX);
            }
        })));
        TOGGLE_ACTIONS.add((Pair<Predicate<ItemStack>, HoldToggleAction>)new Pair(stack -> stack.m_41720_() instanceof DullKnifeSword, (Object)new HoldToggleAction(player -> {
            if (player.m_9236_().m_5776_()) {
                int emotionIndex = ModUtils.getTextureIdx(player.m_21205_());
                DullKnifeSword.EmotionColor emotion = DullKnifeSword.EmotionColor.byId(emotionIndex);
                EnvironmentColorManager.setColor(EnvironmentColorManager.ColorType.SKY, emotion.primaryColor);
                EnvironmentColorManager.setColor(EnvironmentColorManager.ColorType.FOG, emotion.secondaryColor);
            }
        }, player -> EnvironmentColorManager.resetAllColors())));
        TOGGLE_ACTIONS.add((Pair<Predicate<ItemStack>, HoldToggleAction>)new Pair(stack -> stack.m_41720_() instanceof BaseMagicTome, (Object)new HoldToggleAction(player -> {}, player -> {
            ItemStack main = player.m_21205_();
            Item patt10385$temp = main.m_41720_();
            if (patt10385$temp instanceof BaseMagicTome) {
                BaseMagicTome tome = (BaseMagicTome)patt10385$temp;
                tome.closeBook(player, main);
            }
        })));
        TOGGLE_ACTIONS.add((Pair<Predicate<ItemStack>, HoldToggleAction>)new Pair(stack -> stack.m_41720_() instanceof ThunderboltTrident, (Object)new HoldToggleAction(player -> {
            if (!(player.m_9236_() instanceof ServerLevel)) {
                EntityEffect effect = new EntityEffect(ModResources.LIGHTNING_AURA_FX, player.m_9236_(), (Entity)player, EntityEffect.AutoRotate.NONE);
                effect.start();
            }
        }, player -> {
            if (!(player.m_9236_() instanceof ServerLevel)) {
                ModUtils.removeFX((Entity)player, ModResources.LIGHTNING_AURA_FX);
            }
        })));
    }

    public record HoldToggleAction(HoldEvent onHold, HoldEvent onRelease) {
    }

    @FunctionalInterface
    public static interface HoldEvent {
        public void run(Player var1);
    }
}

