/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.base;

import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.goo.brutality.client.renderers.armor.BrutalityArmorRenderer;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityGeoItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class BrutalityArmorItem
extends ArmorItem
implements BrutalityGeoItem {
    private final List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents;
    public String identifier;
    public Rarity rarity;
    AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public BrutalityArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pMaterial, pType, new Item.Properties());
        this.rarity = rarity;
        this.descriptionComponents = descriptionComponents;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/armor/" + this.m_40401_().toString().toLowerCase(Locale.ROOT) + "_armor.png")).toString();
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack pStack) {
        return this.rarity;
    }

    @NotNull
    public Component m_7626_(ItemStack pStack) {
        return this.brutalityNameHandler(pStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        this.brutalityTooltipHandler(pStack, pTooltipComponents, this.descriptionComponents, this.rarity);
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.NONE;
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.ItemType.ARMOR;
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    try {
                        this.renderer = new BrutalityArmorRenderer();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to instantiate GeoArmorRenderer: " + e);
                    }
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }
}

