/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.belt;

import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class BattleScars
extends BrutalityCurioItem {
    UUID BATTLE_SCARS_RAGE_GAIN_UUID = UUID.fromString("551269f9-4bd5-4a74-a03d-55be778f39bc");

    public BattleScars(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.BELT;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        AttributeInstance rageGainAttr;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player && (rageGainAttr = (player = (Player)livingEntity).m_21051_((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get())) != null) {
            List<MobEffectInstance> harmfulEffects = player.m_21220_().stream().toList().stream().filter(effect -> !effect.m_19544_().m_19486_()).toList();
            if (!harmfulEffects.isEmpty()) {
                rageGainAttr.m_22120_(this.BATTLE_SCARS_RAGE_GAIN_UUID);
                rageGainAttr.m_22118_(new AttributeModifier(this.BATTLE_SCARS_RAGE_GAIN_UUID, "Temporary Speed Bonus", (double)((float)harmfulEffects.size() * 0.15f), AttributeModifier.Operation.MULTIPLY_TOTAL));
            } else {
                rageGainAttr.m_22120_(this.BATTLE_SCARS_RAGE_GAIN_UUID);
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        AttributeInstance rageGainAttr = slotContext.entity().m_21051_((Attribute)ModAttributes.RAGE_GAIN_MULTIPLIER.get());
        if (rageGainAttr != null) {
            rageGainAttr.m_22120_(this.BATTLE_SCARS_RAGE_GAIN_UUID);
        }
    }
}

