/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.lowdragmc.lowdraglib.networking.IPacket;
import com.lowdragmc.photon.PhotonNetworking;
import com.lowdragmc.photon.client.fx.EntityEffect;
import com.lowdragmc.photon.command.EntityEffectCommand;
import com.lowdragmc.photon.command.RemoveEntityEffectCommand;
import java.util.List;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.util.ModResources;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import top.theillusivec4.curios.api.SlotContext;

public class CelestialStarboard
extends BrutalityCurioItem {
    private boolean wasOnGround;

    public CelestialStarboard(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> state.setAndContinue(RawAnimation.begin().thenLoop("hide"))).triggerableAnim("spin", RawAnimation.begin().thenLoop("spin"))});
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        super.onEquip(slotContext, prevStack, stack);
        if (ModList.get().isLoaded("photon")) {
            LivingEntity livingEntity = slotContext.entity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            EntityEffectCommand command = new EntityEffectCommand();
            command.setLocation(ModResources.CELESTIAL_STARBOARD_FX.getFxLocation());
            command.setEntities(List.of(player));
            command.setAutoRotate(EntityEffect.AutoRotate.FORWARD);
            PhotonNetworking.NETWORK.sendToAll((IPacket)command);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (ModList.get().isLoaded("photon")) {
            RemoveEntityEffectCommand command = new RemoveEntityEffectCommand();
            command.setLocation(ModResources.CELESTIAL_STARBOARD_FX.getFxLocation());
            command.setEntities(List.of(slotContext.entity()));
            PhotonNetworking.NETWORK.sendToAll((IPacket)command);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            if (Minecraft.m_91087_().f_91074_ == player && Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) {
                if (!player.m_36335_().m_41519_(stack.m_41720_()) && Minecraft.m_91087_().f_91066_.f_92090_.m_90857_()) {
                    Vec3 lookVec = player.m_20252_(1.0f).m_82541_();
                    Vec3 lockedVec = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_);
                    player.m_246865_(lockedVec.m_82490_(2.0));
                    player.m_36335_().m_41524_(stack.m_41720_(), 60);
                }
                if (player.m_20184_().m_7098_() < 0.5) {
                    player.m_246865_(new Vec3(0.0, 0.125, 0.0));
                }
            }
        } else {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!player.m_20096_() && this.wasOnGround) {
                this.triggerArmorAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "spin");
                this.wasOnGround = false;
            } else if (player.m_20096_() && !this.wasOnGround) {
                this.stopTriggeredArmorAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), "controller", "spin");
                this.wasOnGround = true;
            }
        }
    }
}

