/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class CryptoWallet
extends BrutalityCurioItem {
    UUID CRYPTO_CHARM_AD_UUID = UUID.fromString("a0dcfef5-8322-4542-a40a-ce5c7f3bb236");
    UUID CRYPTO_CHARM_AS_UUID = UUID.fromString("99e26a45-2d98-4064-b934-2faa1e6dcae3");
    private static final Object2FloatOpenHashMap<UUID> END_COIN_OLD_BONUS_MAP = new Object2FloatOpenHashMap();
    private static final Object2FloatOpenHashMap<UUID> NETHER_COIN_OLD_BONUS_MAP = new Object2FloatOpenHashMap();

    public CryptoWallet(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity() != null) {
            LivingEntity livingEntity = slotContext.entity();
            UUID uuid = livingEntity.m_20148_();
            CuriosApi.getCuriosInventory((LivingEntity)livingEntity).ifPresent(handler -> {
                float netherCoinNewBonus;
                float netherCoinOriginalBonus;
                AttributeInstance attackSpeed;
                float endCoinNewBonus;
                float endCoinOriginalBonus;
                AttributeInstance attackDamage = livingEntity.m_21051_(Attributes.f_22281_);
                if (attackDamage != null & (endCoinOriginalBonus = END_COIN_OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f)) != (endCoinNewBonus = stack.m_41784_().m_128457_("endCoin"))) {
                    END_COIN_OLD_BONUS_MAP.put((Object)uuid, endCoinNewBonus);
                    attackDamage.m_22120_(this.CRYPTO_CHARM_AD_UUID);
                    attackDamage.m_22118_(new AttributeModifier(this.CRYPTO_CHARM_AD_UUID, "Temporary AD Bonus", (double)endCoinNewBonus, AttributeModifier.Operation.ADDITION));
                }
                if ((attackSpeed = livingEntity.m_21051_(Attributes.f_22283_)) != null & (netherCoinOriginalBonus = NETHER_COIN_OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f)) != (netherCoinNewBonus = stack.m_41784_().m_128457_("netherCoin"))) {
                    NETHER_COIN_OLD_BONUS_MAP.put((Object)uuid, netherCoinNewBonus);
                    attackSpeed.m_22120_(this.CRYPTO_CHARM_AS_UUID);
                    attackSpeed.m_22118_(new AttributeModifier(this.CRYPTO_CHARM_AS_UUID, "Temporary Speed Bonus", (double)netherCoinNewBonus, AttributeModifier.Operation.ADDITION));
                }
            });
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.CRYPTO_CHARM_AD_UUID, "Temporary AD Bonus", (double)stack.m_41784_().m_128457_("endCoin"), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(this.CRYPTO_CHARM_AS_UUID, "Temporary AS Bonus", (double)stack.m_41784_().m_128457_("netherCoin"), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

