/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class ExponentialCharm
extends BrutalityCurioItem {
    float eMult = 0.0314f;
    float e = 3.14f;
    private final UUID EXPONENTIAL_CHARM_ARMOR_TOUGHNESS_UUID = UUID.fromString("3d5a255a-ba29-4ef8-a062-c1e2f60b4de5");
    private final UUID EXPONENTIAL_CHARM_ARMOR_UUID = UUID.fromString("34071937-161d-4ffd-9389-470bec894a2a");
    private final UUID EXPONENTIAL_CHARM_LUCK_UUID = UUID.fromString("6773ccc6-f8ed-4c68-856a-aa99c5ded49c");
    private final UUID EXPONENTIAL_CHARM_MAX_HP_UUID = UUID.fromString("721ac022-478d-4161-ba45-91a8dfe21d2e");
    private final UUID EXPONENTIAL_CHARM_KB_RESIST_UUID = UUID.fromString("25343e75-c9fa-4d8d-8485-a884e4e3e467");

    public ExponentialCharm(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(this.EXPONENTIAL_CHARM_KB_RESIST_UUID, "KB Resist Buff", (double)this.eMult, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(this.EXPONENTIAL_CHARM_LUCK_UUID, "Luck Buff", (double)this.eMult, AttributeModifier.Operation.MULTIPLY_TOTAL));
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(this.EXPONENTIAL_CHARM_ARMOR_UUID, "Armor Buff", (double)this.e, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(this.EXPONENTIAL_CHARM_ARMOR_TOUGHNESS_UUID, "Armor Toughness Buff", (double)this.e, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.EXPONENTIAL_CHARM_MAX_HP_UUID, "HP Buff", (double)this.e, AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCapability(BrutalityCapabilities.PLAYER_COMBO_CAP).ifPresent(cap -> {
                cap.resetAll();
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
            });
        }
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity()).map(handler -> handler.isEquipped((Item)BrutalityModItems.SCIENTIFIC_CALCULATOR.get())).orElse(false);
    }
}

