/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class KnightsPendant
extends BrutalityCurioItem {
    UUID KNIGHTS_PENDANT_SWORD_DAMAGE_UUID = UUID.fromString("49baa2f0-d7f6-4e47-8a28-571b5074989d");
    UUID KNIGHTS_PENDANT_LETHALITY_UUID = UUID.fromString("a23c6244-a53c-4c40-8f74-7db93bb8b4f4");
    UUID KNIGHTS_PENDANT_ARMOR_PEN_UUID = UUID.fromString("3ddff39e-688d-420e-b768-25ea7d33bad8");
    private static final Object2BooleanOpenHashMap<UUID> OLD_BONUS_MAP = new Object2BooleanOpenHashMap();

    public KnightsPendant(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.NECKLACE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance attackDamage = livingEntity.m_21051_(Attributes.f_22281_);
            boolean active = livingEntity.m_21223_() / livingEntity.m_21233_() < 0.75f;
            UUID uuid = livingEntity.m_20148_();
            boolean wasActive = OLD_BONUS_MAP.getOrDefault((Object)uuid, false);
            if (attackDamage != null && wasActive != active) {
                OLD_BONUS_MAP.put((Object)uuid, active);
                attackDamage.m_22120_(this.KNIGHTS_PENDANT_ARMOR_PEN_UUID);
                if (active) {
                    attackDamage.m_22118_(new AttributeModifier(this.KNIGHTS_PENDANT_ARMOR_PEN_UUID, "Armor Pen Buff", 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeBoolean((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LivingEntity livingEntity;
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)((Attribute)ModAttributes.SWORD_DAMAGE.get()), (Object)new AttributeModifier(this.KNIGHTS_PENDANT_SWORD_DAMAGE_UUID, "Sword Damage Buff", 4.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ModAttributes.LETHALITY.get()), (Object)new AttributeModifier(this.KNIGHTS_PENDANT_LETHALITY_UUID, "Lethality Buff", 4.0, AttributeModifier.Operation.ADDITION));
        if (slotContext.entity() != null && (livingEntity = slotContext.entity()).m_21223_() / livingEntity.m_21233_() < 0.75f) {
            builder.put((Object)((Attribute)ModAttributes.ARMOR_PENETRATION.get()), (Object)new AttributeModifier(this.KNIGHTS_PENDANT_ARMOR_PEN_UUID, "Armor Pen Buff", 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }
}

