/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.charm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class Pride
extends BrutalityCurioItem {
    UUID PRIDE_AD_UUID = UUID.fromString("81d46a1b-a3aa-4cb8-8999-d60df56c0cb7");
    private static final Object2FloatOpenHashMap<UUID> OLD_BONUS_MAP = new Object2FloatOpenHashMap();

    public Pride(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.CHARM;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance attackDamage = livingEntity.m_21051_(Attributes.f_22281_);
            float newBonus = livingEntity.m_21223_() / livingEntity.m_21233_() * 0.4f;
            UUID uuid = livingEntity.m_20148_();
            float oldBonus = OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f);
            if (attackDamage != null && oldBonus != newBonus) {
                OLD_BONUS_MAP.put((Object)uuid, newBonus);
                attackDamage.m_22120_(this.PRIDE_AD_UUID);
                attackDamage.m_22118_(new AttributeModifier(this.PRIDE_AD_UUID, "AD Bonus", (double)newBonus, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        if (slotContext.entity() != null) {
            ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
            LivingEntity livingEntity = slotContext.entity();
            float bonus = livingEntity.m_21223_() / livingEntity.m_21233_() * 0.4f;
            if (bonus > 0.0f) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.PRIDE_AD_UUID, "AD Buff", (double)bonus, AttributeModifier.Operation.ADDITION));
            }
            return builder.build();
        }
        return super.getAttributeModifiers(slotContext, uuid, stack);
    }
}

