/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.heart;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import top.theillusivec4.curios.api.SlotContext;

public class BrutalHeart
extends BrutalityCurioItem {
    UUID BRUTAL_HEART_CRIT_CHANCE_UUID = UUID.fromString("ef1d5c30-926e-11f0-9a87-325096b39f47");
    UUID BRUTAL_HEART_CRIT_DAMAGE_UUID = UUID.fromString("ef1d5ec4-926e-11f0-b2ee-325096b39f47");
    UUID BRUTAL_HEART_MAX_HEALTH_UUID = UUID.fromString("ef1d5f64-926e-11f0-b2b9-325096b39f47");
    private static final Object2FloatOpenHashMap<UUID> OLD_HEALTH_MAP = new Object2FloatOpenHashMap();

    public BrutalHeart(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.HEART;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance critChance = livingEntity.m_21051_((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get());
            UUID uuid = livingEntity.m_20148_();
            if (critChance != null) {
                float newHealth = livingEntity.m_21233_();
                float oldHealth = OLD_HEALTH_MAP.getOrDefault((Object)uuid, 0.0f);
                if ((double)Math.abs(oldHealth - newHealth) > 1.0E-4) {
                    float originalHealth = newHealth * 1.3333334f;
                    float healthDiff = originalHealth - newHealth;
                    OLD_HEALTH_MAP.put((Object)uuid, newHealth);
                    critChance.m_22120_(this.BRUTAL_HEART_CRIT_CHANCE_UUID);
                    critChance.m_22118_(new AttributeModifier(this.BRUTAL_HEART_CRIT_CHANCE_UUID, "Crit Chance Buff", (double)(healthDiff * 0.05f), AttributeModifier.Operation.MULTIPLY_BASE));
                }
            }
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(this.BRUTAL_HEART_MAX_HEALTH_UUID, "Health Debuff", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
        builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_DAMAGE.get()), (Object)new AttributeModifier(this.BRUTAL_HEART_CRIT_DAMAGE_UUID, "Crit Damage Buff", 0.25, AttributeModifier.Operation.MULTIPLY_BASE));
        if (slotContext.entity() != null) {
            LivingEntity livingEntity = slotContext.entity();
            float alteredHealth = livingEntity.m_21233_();
            float originalHealth = alteredHealth * 1.3333334f;
            float healthDiff = originalHealth - alteredHealth;
            builder.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get()), (Object)new AttributeModifier(this.BRUTAL_HEART_CRIT_CHANCE_UUID, "Crit Chance Buff", (double)healthDiff * 0.05, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        return builder.build();
    }
}

