/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.necklace;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class AbyssalNecklace
extends BrutalityCurioItem {
    UUID ABYSS_NECKLACE_AD_UUID = UUID.fromString("de956292-15b7-432d-b5e6-55ca6be388ac");
    private static final Object2FloatOpenHashMap<UUID> OLD_BONUS_MAP = new Object2FloatOpenHashMap();
    UUID ABYSS_NECKLACE_SWIM_SPEED_UUID = UUID.fromString("8e16861a-63a6-4444-9252-faf7211f6745");

    public AbyssalNecklace(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.NECKLACE;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity() != null && !(livingEntity = slotContext.entity()).m_9236_().m_5776_() && livingEntity.f_19797_ % 10 == 0) {
            AttributeInstance attackDamage = livingEntity.m_21051_(Attributes.f_22281_);
            UUID uuid = livingEntity.m_20148_();
            if (attackDamage != null) {
                if (livingEntity.m_20071_()) {
                    float newBonus = Math.max((float)(5.0 - (livingEntity.m_20186_() + 64.0) / 384.0 * 5.0), 0.0f);
                    float oldBonus = OLD_BONUS_MAP.getOrDefault((Object)uuid, 0.0f);
                    if ((double)Math.abs(oldBonus - newBonus) > 1.0E-4) {
                        OLD_BONUS_MAP.put((Object)uuid, newBonus);
                        attackDamage.m_22120_(this.ABYSS_NECKLACE_AD_UUID);
                        attackDamage.m_22118_(new AttributeModifier(this.ABYSS_NECKLACE_AD_UUID, "Depth AD Bonus", (double)newBonus, AttributeModifier.Operation.ADDITION));
                    }
                } else {
                    attackDamage.m_22120_(this.ABYSS_NECKLACE_AD_UUID);
                    OLD_BONUS_MAP.removeFloat((Object)uuid);
                }
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (slotContext.entity() != null) {
            OLD_BONUS_MAP.removeFloat((Object)slotContext.entity().m_20148_());
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        ImmutableMultimap.Builder builder = new ImmutableMultimap.Builder();
        builder.put((Object)((Attribute)ForgeMod.SWIM_SPEED.get()), (Object)new AttributeModifier(this.ABYSS_NECKLACE_SWIM_SPEED_UUID, "MS Buff", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
        if (slotContext.entity() != null && slotContext.entity().m_20071_()) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.ABYSS_NECKLACE_AD_UUID, "Depth AD Bonus", (double)Math.max((float)(5.0 - (slotContext.entity().m_20186_() + 64.0) / 384.0 * 5.0), 0.0f), AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }
}

