/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.curios.ring;

import java.util.List;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityCurioItem;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundDamageEntityPacket;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class RoadRunnersRing
extends BrutalityCurioItem {
    private float xOld;
    private float zOld;

    public RoadRunnersRing(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 3, 14, false, true));
            if (player.m_9236_().m_5776_()) {
                Vec3 currentPos = player.m_20182_();
                Vec3 direction = currentPos.m_82546_(new Vec3((double)this.xOld, player.m_20186_(), (double)this.zOld));
                if (direction.m_82556_() > 0.2 && player.f_19862_) {
                    Vec3 wallNormal = this.getWallNormal(player, direction);
                    float impactFactor = (float)Math.abs(direction.m_82541_().m_82526_(wallNormal));
                    if (impactFactor > 0.7f) {
                        float damage = (float)(direction.m_82556_() * 15.0);
                        this.triggerCollisionEffects(player, damage);
                    }
                }
                this.xOld = (float)currentPos.f_82479_;
                this.zOld = (float)currentPos.f_82481_;
            }
        }
    }

    private Vec3 getWallNormal(Player player, Vec3 moveDirection) {
        BlockPos collisionPos = player.m_20183_();
        if (player.m_9236_().m_8055_(collisionPos.m_122029_()).m_280296_()) {
            return new Vec3(-1.0, 0.0, 0.0);
        }
        if (player.m_9236_().m_8055_(collisionPos.m_122024_()).m_280296_()) {
            return new Vec3(1.0, 0.0, 0.0);
        }
        if (player.m_9236_().m_8055_(collisionPos.m_122012_()).m_280296_()) {
            return new Vec3(0.0, 0.0, 1.0);
        }
        if (player.m_9236_().m_8055_(collisionPos.m_122019_()).m_280296_()) {
            return new Vec3(0.0, 0.0, -1.0);
        }
        return moveDirection.m_82541_().m_82490_(-1.0);
    }

    private SoundEvent getFallDamageSound(float damage) {
        return damage > 4.0f ? SoundEvents.f_11916_ : SoundEvents.f_11908_;
    }

    private void triggerCollisionEffects(Player player, float damage) {
        PacketHandler.sendToServer(new ServerboundDamageEntityPacket(player.m_19879_(), damage, player.m_269291_().m_269515_()));
        player.m_5496_(this.getFallDamageSound(damage), 1.0f, Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f));
    }

    @Override
    public BrutalityCategories category() {
        return BrutalityCategories.CurioType.RING;
    }
}

