/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.axe;

import java.util.List;
import net.goo.brutality.entity.projectile.generic.CruelSunEntity;
import net.goo.brutality.item.base.BrutalityAxeItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.core.animation.AnimatableManager;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RhittaAxe
extends BrutalityAxeItem {
    public RhittaAxe(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeLeft) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pStack.m_41784_().m_128441_("ID")) {
                this.despawnCruelSun(player, pStack);
            } else {
                this.spawnCruelSun(player, pStack);
            }
            player.m_36335_().m_41524_(pStack.m_41720_(), 40);
        }
    }

    public void spawnCruelSun(Player player, ItemStack pStack) {
        CruelSunEntity cruelSun = new CruelSunEntity((EntityType<? extends ThrowableProjectile>)((EntityType)BrutalityModEntities.CRUEL_SUN_ENTITY.get()), player.m_9236_());
        cruelSun.m_5602_((Entity)player);
        cruelSun.m_146884_(player.m_20318_(1.0f).m_82520_(0.0, 10.0, 0.0));
        player.m_9236_().m_7967_((Entity)cruelSun);
        pStack.m_41784_().m_128405_("ID", cruelSun.m_19879_());
    }

    public void despawnCruelSun(Player player, ItemStack pStack) {
        if (player.m_9236_() instanceof ServerLevel) {
            CruelSunEntity cruelSun = this.getOwnedCruelSunFromID(player, pStack);
            if (cruelSun != null) {
                cruelSun.m_146870_();
            }
            pStack.m_41784_().m_128473_("ID");
        }
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ServerLevel serverLevel;
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        Level level = pPlayer.m_9236_();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46461_()) {
            pPlayer.m_6672_(pUsedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pStack.m_41784_().m_128441_("ID")) {
                if (pIsSelected) {
                    if (this.getOwnedCruelSunFromID(player, pStack) == null) {
                        this.despawnCruelSun(player, pStack);
                    }
                } else {
                    this.despawnCruelSun(player, pStack);
                }
            }
            if (!pLevel.f_46443_ && pLevel.m_46462_()) {
                this.despawnCruelSun(player, pStack);
            }
        }
    }

    public static float computeAttackDamageBonus(Level world) {
        float time = world.m_46468_() % 24000L;
        float bonus = (float)Math.cos(Math.PI * (double)(time - 6000.0f) / 12000.0);
        bonus = Math.max(0.0f, bonus);
        return bonus * 20.0f;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    private CruelSunEntity getOwnedCruelSunFromID(Player player, ItemStack pStack) {
        Entity cruelSun = player.m_9236_().m_6815_(pStack.m_41784_().m_128451_("ID"));
        if (cruelSun instanceof CruelSunEntity) {
            return (CruelSunEntity)cruelSun;
        }
        return null;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.despawnCruelSun(player, item);
        return super.onDroppedByPlayer(item, player);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

