/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import net.goo.brutality.entity.base.BrutalityRay;
import net.goo.brutality.entity.capabilities.EntityCapabilities;
import net.goo.brutality.entity.projectile.ray.LastPrismRay;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.magic.SpellCastingHandler;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityDamageTypes;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class LastPrismItem
extends BrutalityGenericItem {
    private static final String LAST_PRISM_ID = "LastPrismId";

    public LastPrismItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public int getMaxDamage(ItemStack stack) {
        return 3000;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    public static void setLastPrismRay(ItemStack stack, int id) {
        stack.m_41784_().m_128405_(LAST_PRISM_ID, id);
    }

    public static Entity getLastPrismRay(Level level, ItemStack stack) {
        return level.m_6815_(stack.m_41784_().m_128451_(LAST_PRISM_ID));
    }

    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (SpellCastingHandler.getManaHandler(pPlayer).manaValue() < 15.0f) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        pPlayer.m_36335_().m_41524_(stack.m_41720_(), 20);
        LastPrismRay lastPrismRay = new LastPrismRay((EntityType<? extends BrutalityRay>)((EntityType)BrutalityModEntities.LAST_PRISM_RAY.get()), pLevel);
        lastPrismRay.m_5602_((Entity)pPlayer);
        lastPrismRay.m_146884_(pPlayer.m_20154_().m_82520_(pPlayer.m_20185_(), pPlayer.m_20188_(), pPlayer.m_20189_()));
        LastPrismItem.setLastPrismRay(stack, lastPrismRay.m_19879_());
        pLevel.m_7967_((Entity)lastPrismRay);
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        Entity entity = LastPrismItem.getLastPrismRay(pLevel, pStack);
        if (entity instanceof LastPrismRay) {
            LastPrismRay lastPrismRay = (LastPrismRay)entity;
            lastPrismRay.triggerAnim("controller", "despawn");
            DelayedTaskScheduler.queueServerWork(pLevel, 20, () -> ((LastPrismRay)lastPrismRay).m_146870_());
        }
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    public void m_5929_(Level pLevel, LivingEntity owner, ItemStack pStack, int pRemainingUseDuration) {
        Entity entity;
        if (!(owner instanceof Player)) {
            return;
        }
        Player player = (Player)owner;
        if (pRemainingUseDuration % 10 == 0) {
            EntityCapabilities.PlayerManaCap playerManaCap;
            if (!player.m_9236_().m_5776_()) {
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(player.m_19879_(), (Entity)player));
            }
            if ((playerManaCap = SpellCastingHandler.getManaHandler(player)).manaValue() > 15.0f) {
                playerManaCap.decrementMana(15.0f);
            } else {
                player.m_21253_();
                return;
            }
        }
        if ((entity = LastPrismItem.getLastPrismRay(pLevel, pStack)) instanceof LastPrismRay) {
            LastPrismRay lastPrismRay = (LastPrismRay)entity;
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                ModUtils.RayData<LivingEntity> rayData = ModUtils.getEntitiesInRay(LivingEntity.class, owner, 150.0f, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 1.0f, e -> e != owner, 100, loc -> serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.LAST_PRISM_RAY_PARTICLE.get()), loc.f_82479_, loc.f_82480_, loc.f_82481_, 1, 1.0, 1.0, 1.0, 0.0));
                lastPrismRay.setDataMaxLength(rayData.distance() - 2);
                if (rayData.entityList() == null) {
                    return;
                }
                for (LivingEntity target : rayData.entityList()) {
                    target.m_6469_(BrutalityDamageTypes.last_prism((Entity)owner), 2.0f);
                }
                Vec3 endPos = rayData.endPos();
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.LAST_PRISM_RAY_PARTICLE.get()), endPos.f_82479_, endPos.f_82480_, endPos.f_82481_, 5, 1.0, 1.0, 1.0, 0.0);
            }
            if ((this.m_8105_(pStack) - pRemainingUseDuration) % 6 == 0) {
                owner.m_5496_((SoundEvent)BrutalityModSounds.LAST_PRISM_USE.get(), 3.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot slot, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (slot == EquipmentSlot.OFFHAND && living.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == this) {
                return false;
            }
        }
        return super.canEquip(stack, slot, entity);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void m_6883_(ItemStack stack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pIsSelected) {
            return;
        }
        Entity entity = LastPrismItem.getLastPrismRay(pLevel, stack);
        if (entity instanceof LastPrismRay) {
            LastPrismRay lastPrismRay = (LastPrismRay)entity;
            lastPrismRay.m_146870_();
        }
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        ServerLevel serverLevel;
        Level level = player.m_9236_();
        if (level instanceof ServerLevel && (level = LastPrismItem.getLastPrismRay((Level)(serverLevel = (ServerLevel)level), item)) instanceof LastPrismRay) {
            LastPrismRay lastPrismRay = (LastPrismRay)level;
            lastPrismRay.m_146870_();
        }
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

