/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LeafBlowerItem
extends BrutalityGenericItem {
    private static final String ACTIVE_KEY = "LeafBlowerActive";
    private int tickCounter;

    public LeafBlowerItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    public static void setActive(ItemStack stack, boolean active) {
        stack.m_41784_().m_128379_(ACTIVE_KEY, active);
    }

    public static boolean isActive(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVE_KEY);
    }

    private PlayState predicate(AnimationState animationState) {
        ItemStack stack = (ItemStack)animationState.getData(DataTickets.ITEMSTACK);
        if (LeafBlowerItem.isActive(stack)) {
            animationState.getController().setAnimation(RawAnimation.begin().thenPlay("on").thenLoop("active"));
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().thenPlay("off"));
        return PlayState.STOP;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.f_46443_) {
            pPlayer.m_6672_(pUsedHand);
            pPlayer.m_5496_((SoundEvent)BrutalityModSounds.LEAF_BLOWER_ON.get(), 0.25f, 1.0f);
        }
        if (!pLevel.f_46443_) {
            LeafBlowerItem.setActive(pPlayer.m_21120_(pUsedHand), true);
        }
        return InteractionResultHolder.m_19100_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player pPlayer = (Player)pLivingEntity;
            pPlayer.m_5496_((SoundEvent)BrutalityModSounds.LEAF_BLOWER_OFF.get(), 0.25f, 1.0f);
            this.tickCounter = 0;
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (LeafBlowerItem.isActive(pStack)) {
            Player pPlayer;
            if (pLevel.f_46443_ && pEntity instanceof Player) {
                pPlayer = (Player)pEntity;
                ++this.tickCounter;
                if (this.tickCounter >= 28 && this.tickCounter % 5 == 0) {
                    pPlayer.m_5496_((SoundEvent)BrutalityModSounds.LEAF_BLOWER_ACTIVE.get(), 0.25f, 1.0f);
                }
            }
            if (!pLevel.f_46443_ && pEntity instanceof Player) {
                boolean eitherHandsActive;
                pPlayer = (Player)pEntity;
                ItemStack mainHandStack = pPlayer.m_21205_();
                ItemStack offHandStack = pPlayer.m_21206_();
                boolean bothHandsActive = mainHandStack.m_41720_() instanceof LeafBlowerItem && offHandStack.m_41720_() instanceof LeafBlowerItem;
                boolean bl = eitherHandsActive = mainHandStack.m_41720_() instanceof LeafBlowerItem || offHandStack.m_41720_() instanceof LeafBlowerItem;
                if (bothHandsActive || eitherHandsActive) {
                    float range = bothHandsActive ? 12.0f : 6.0f;
                    float pushScale = bothHandsActive ? 0.5f : 0.25f;
                    Vec3 viewVector = pPlayer.m_20252_(1.0f);
                    Vec3 eyePosition = pPlayer.m_146892_();
                    Vec3 targetPosition = eyePosition.m_82549_(viewVector.m_82490_((double)range));
                    AABB searchBox = new AABB(eyePosition, targetPosition).m_82400_(bothHandsActive ? 1.5 : 1.0);
                    List entities = pLevel.m_6249_((Entity)pPlayer, searchBox, entity -> entity instanceof LivingEntity);
                    for (Entity target : entities) {
                        if (!pPlayer.m_142582_(target) || pPlayer.m_5842_()) continue;
                        Vec3 pushDirection = target.m_20182_().m_82546_(pPlayer.m_20182_()).m_82541_().m_82490_((double)pushScale);
                        target.m_246865_(pushDirection);
                        if (!(target instanceof ServerPlayer)) continue;
                        ServerPlayer serverTarget = (ServerPlayer)target;
                        serverTarget.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                    }
                    if (bothHandsActive && pPlayer instanceof ServerPlayer) {
                        Vec3 oppositePushVector = new Vec3(-pPlayer.m_20154_().f_82479_, -pPlayer.m_20154_().f_82480_, -pPlayer.m_20154_().f_82481_).m_82541_();
                        Vec3 playerRecoilVector = oppositePushVector.m_82490_((double)0.04f);
                        pPlayer.m_246865_(playerRecoilVector);
                        ((ServerPlayer)pPlayer).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)pPlayer));
                    }
                } else {
                    LeafBlowerItem.setActive(pStack, false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void cancelFallDamage(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            ItemStack mainStack = player.m_21205_();
            ItemStack offStack = player.m_21206_();
            Item mainItem = mainStack.m_41720_();
            Item offItem = offStack.m_41720_();
            if (mainItem instanceof LeafBlowerItem && offItem instanceof LeafBlowerItem && mainStack.m_41784_().m_128471_(ACTIVE_KEY) && offStack.m_41784_().m_128471_(ACTIVE_KEY)) {
                event.setCanceled(true);
            }
        }
    }
}

