/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.generic;

import java.util.List;
import net.goo.brutality.entity.base.BrutalityAbstractThrowingProjectile;
import net.goo.brutality.entity.projectile.trident.physics_projectile.ThrownStyrofoamCup;
import net.goo.brutality.item.base.BrutalityGenericItem;
import net.goo.brutality.registry.BrutalityDamageTypes;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class StyrofoamCupItem
extends BrutalityGenericItem {
    protected String[] types = new String[]{"", "_water"};

    public StyrofoamCupItem(Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(rarity, descriptionComponents);
    }

    @Override
    public String texture(@javax.annotation.Nullable ItemStack stack) {
        return "styrofoam_cup" + this.types[ModUtils.getTextureIdx(stack)];
    }

    @Override
    @NotNull
    public Component m_7626_(ItemStack pStack) {
        return Component.m_237115_((String)("item.brutality.styrofoam_cup" + this.types[ModUtils.getTextureIdx(pStack)]));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return ModUtils.getTextureIdx(pStack) == 0 ? UseAnim.SPEAR : UseAnim.DRINK;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            int i = this.m_8105_(pStack) - pTimeCharged;
            if (ModUtils.getTextureIdx(pStack) == 0 && i >= 10 && !pLevel.f_46443_) {
                this.launchProjectile(pLevel, player);
                player.m_150109_().m_36057_(pStack);
            }
        }
    }

    public int m_8105_(ItemStack pStack) {
        return ModUtils.getTextureIdx(pStack) == 0 ? 72000 : 40;
    }

    public boolean m_41472_() {
        return true;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return new FoodProperties.Builder().m_38767_();
    }

    @NotNull
    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (ModUtils.getTextureIdx(pStack) != 0) {
            if (pLivingEntity instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)pLivingEntity;
                CriteriaTriggers.f_10592_.m_23682_(serverplayer, pStack);
                serverplayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            if (pStack.m_41619_()) {
                return this.m_7968_();
            }
            if (pLivingEntity instanceof Player) {
                Player player = (Player)pLivingEntity;
                if (!player.m_150110_().f_35937_) {
                    ItemStack itemstack = this.m_7968_();
                    pStack.m_41774_(1);
                    int slot = player.m_150109_().m_36030_(pStack);
                    if (slot != -1) {
                        player.m_150109_().m_6836_(slot, itemstack);
                    } else {
                        player.m_36176_(itemstack, false);
                    }
                }
            }
            return pStack;
        }
        return ItemStack.f_41583_;
    }

    public void launchProjectile(Level pLevel, Player player) {
        ThrownStyrofoamCup thrownEntity = new ThrownStyrofoamCup((EntityType<? extends BrutalityAbstractThrowingProjectile>)((EntityType)BrutalityModEntities.STYROFOAM_CUP.get()), player, pLevel, BrutalityDamageTypes.THROWING_BLUNT);
        thrownEntity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.75f, 1.0f);
        if (player.m_150110_().f_35937_) {
            thrownEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        pLevel.m_7967_((Entity)thrownEntity);
    }
}

