/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.scythe;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.base.BrutalityScytheItem;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;

@Mod.EventBusSubscriber(modid="brutality")
public class DarkinScythe
extends BrutalityScytheItem {
    protected String[] types = new String[]{"", "_shadow_assassin", "_rhaast"};
    private final UUID DARKIN_SCYTHE_MS_UUID = UUID.fromString("c0aa6baf-16a7-45e1-a65c-cfb82a65ff4c");
    private final UUID DARKIN_SCYTHE_AS_UUID = UUID.fromString("5386a75c-a1df-4b83-a62d-04dcb0fce7ff");
    private final UUID DARKIN_SCYTHE_AD_UUID = UUID.fromString("57b3f5d9-9f58-45d0-80f5-11ad07675bc6");

    public DarkinScythe(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public String texture(@javax.annotation.Nullable ItemStack stack) {
        return "darkin_scythe" + this.types[ModUtils.getTextureIdx(stack)];
    }

    @Override
    public String model(ItemStack stack) {
        return "darkin_scythe" + this.types[ModUtils.getTextureIdx(stack)];
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int index = ModUtils.getTextureIdx(pStack);
        pTooltipComponents.add((Component)Component.m_237115_((String)"brutality.description.type.on_shift_right_click"));
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.on_shift_right_click.1"));
        pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.on_shift_right_click.2"));
        if (index == 1) {
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.shadow_assasin"));
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"brutality.description.type.on_hit"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.on_hit.1"));
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"brutality.description.type.on_right_click"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.on_right_click.1"));
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"brutality.description.type.passive"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.passive.1"));
        }
        if (index == 2) {
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.darkin"));
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"brutality.description.type.on_hit"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.on_hit.2"));
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)"brutality.description.type.on_right_click"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"item.brutality.darkin_scythe.on_right_click.2"));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            float attackSpeed;
            int index = ModUtils.getTextureIdx(stack);
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(this.DARKIN_SCYTHE_AD_UUID, "Weapon damage", (double)(switch (index) {
                case 1 -> {
                    attackSpeed = -0.0f;
                    yield 6.0f;
                }
                case 2 -> {
                    attackSpeed = -3.1f;
                    yield 21.0f;
                }
                default -> {
                    attackSpeed = -2.5f;
                    yield 6.0f;
                }
            }), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(this.DARKIN_SCYTHE_AS_UUID, "Weapon speed", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(this.DARKIN_SCYTHE_MS_UUID, "Move speed", index == 1 ? 0.4 : 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return modifiers;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pUsedHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int index = ModUtils.getTextureIdx(stack);
        if (pPlayer.m_6047_()) {
            pPlayer.m_36335_().m_41524_(stack.m_41720_(), 80);
            ModUtils.setTextureIdx(stack, (index + 1) % 3);
            pLevel.m_247517_(null, pPlayer.m_20097_(), (SoundEvent)BrutalityModSounds.DARKIN_SCYTHE_TRANSFORM.get(index).get(), SoundSource.PLAYERS);
        } else {
            float length = index == 1 ? 14.0f : 10.0f;
            List<LivingEntity> entities = ModUtils.getEntitiesInRay(LivingEntity.class, (LivingEntity)pPlayer, length, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 1.0f, e -> e != pPlayer, 100, null).entityList();
            if (index == 1) {
                for (LivingEntity entity : entities) {
                    pLevel.m_7106_((ParticleOptions)BrutalityModParticles.SHADOW_ASSASIN_PARTICLE.get(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), (double)pLevel.f_46441_.m_188501_() - 0.5, (double)pLevel.f_46441_.m_188501_() - 0.5, (double)pLevel.f_46441_.m_188501_() - 0.5);
                    entity.m_6469_(pPlayer.m_269291_().m_269104_((Entity)pPlayer, null), 6.0f);
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
                }
                pPlayer.m_36335_().m_41524_(stack.m_41720_(), 30);
                pLevel.m_5594_(pPlayer, pPlayer.m_20097_(), (SoundEvent)BrutalityModSounds.GROUND_IMPACT.get(), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.75f, (float)1.0f));
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            if (index == 2) {
                for (LivingEntity entity : entities) {
                    pLevel.m_7106_((ParticleOptions)BrutalityModParticles.RHAAST_PARTICLE.get(), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), (double)pLevel.f_46441_.m_188501_() - 0.5, (double)pLevel.f_46441_.m_188501_() - 0.5, (double)pLevel.f_46441_.m_188501_() - 0.5);
                    entity.m_6469_(pPlayer.m_269291_().m_269075_(pPlayer), 8.0f);
                    entity.m_5997_(0.0, 0.35, 0.0);
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2));
                }
                pPlayer.m_36335_().m_41524_(stack.m_41720_(), 30);
                pLevel.m_5594_(pPlayer, pPlayer.m_20097_(), (SoundEvent)BrutalityModSounds.GROUND_IMPACT.get(), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.75f, (float)1.0f));
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }
}

