/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.spear;

import java.util.List;
import net.goo.brutality.entity.projectile.generic.BlackHole;
import net.goo.brutality.item.base.BrutalitySpearItem;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventHorizonSpear
extends BrutalitySpearItem {
    public EventHorizonSpear(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemstack = pPlayer.m_21120_(pUsedHand);
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeLeft) {
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            if (pStack.m_41784_().m_128441_("ID")) {
                this.despawnBlackHole(player, pStack);
            } else {
                this.spawnBlackHole(player, pStack);
            }
            player.m_36335_().m_41524_(pStack.m_41720_(), 40);
        }
    }

    public void spawnBlackHole(Player player, ItemStack pStack) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_247517_(null, player.m_20097_(), (SoundEvent)BrutalityModSounds.EVENT_HORIZON_DISLODGE.get(), SoundSource.AMBIENT);
            BlackHole blackHole = new BlackHole((EntityType<? extends ThrowableProjectile>)((EntityType)BrutalityModEntities.BLACK_HOLE_ENTITY.get()), (Level)serverLevel);
            blackHole.m_5602_((Entity)player);
            blackHole.m_146884_(player.m_20318_(1.0f).m_82520_(0.0, 2.0, 0.0));
            serverLevel.m_7967_((Entity)blackHole);
            pStack.m_41784_().m_128405_("ID", blackHole.m_19879_());
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)serverLevel), "controller_2", "dislodged");
        }
    }

    public void despawnBlackHole(Player player, ItemStack pStack) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlackHole blackHole = this.getOwnedBlackHoleFromID(player, pStack);
            if (blackHole != null) {
                serverLevel.m_247517_(null, player.m_20097_(), (SoundEvent)BrutalityModSounds.EVENT_HORIZON_RETURN.get(), SoundSource.AMBIENT);
                blackHole.m_146870_();
            }
            pStack.m_41784_().m_128473_("ID");
            this.triggerAnim((Entity)player, GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)serverLevel), "controller_2", "return");
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pStack.m_41784_().m_128441_("ID")) {
                if (pIsSelected) {
                    if (this.getOwnedBlackHoleFromID(player, pStack) == null) {
                        this.despawnBlackHole(player, pStack);
                    }
                } else {
                    this.despawnBlackHole(player, pStack);
                }
            }
        }
    }

    private BlackHole getOwnedBlackHoleFromID(Player player, ItemStack pStack) {
        Entity blackHole = player.m_9236_().m_6815_(pStack.m_41784_().m_128451_("ID"));
        if (blackHole instanceof BlackHole) {
            return (BlackHole)blackHole;
        }
        return null;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.despawnBlackHole(player, item);
        return super.onDroppedByPlayer(item, player);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", state -> state.setAndContinue(RawAnimation.begin().thenLoop("idle")))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller_2", state -> null).triggerableAnim("dislodged", RawAnimation.begin().thenPlayAndHold("dislodged")).triggerableAnim("return", RawAnimation.begin().thenPlayAndHold("return"))});
    }
}

