/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import java.awt.Color;
import java.util.List;
import java.util.Locale;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.registry.BrutalityModItems;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.EnvironmentColorManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;

@Mod.EventBusSubscriber(modid="brutality")
public class DullKnifeSword
extends BrutalitySwordItem {
    public DullKnifeSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        ModUtils.setTextureIdx(stack, 0);
        return stack;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    @NotNull
    public Component m_7626_(ItemStack pStack) {
        String identifier = this.getRegistryName();
        EmotionColor emotionColor = EmotionColor.byId(ModUtils.getTextureIdx(pStack));
        return BrutalityTooltipHelper.tooltipHelper("item.brutality." + identifier, false, null, Float.valueOf(0.5f), Float.valueOf(2.0f), emotionColor.primaryColor, emotionColor.secondaryColor);
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237119_());
        for (EmotionColor emotion : EmotionColor.values()) {
            String emotionKey = emotion.name().toLowerCase(Locale.ROOT);
            pTooltipComponents.add(BrutalityTooltipHelper.tooltipHelper("item.brutality.dull_knife." + emotionKey, true, null, Float.valueOf(0.0f), Float.valueOf(1.0f), emotion.primaryColor, emotion.secondaryColor));
            for (int j = 1; j <= 3; ++j) {
                MutableComponent component = Component.m_237115_((String)("item.brutality.dull_knife." + emotionKey + ".desc." + j));
                if (component.getString().isBlank()) continue;
                pTooltipComponents.add((Component)component.m_130940_(ChatFormatting.BLUE));
            }
            pTooltipComponents.add((Component)Component.m_237119_());
        }
    }

    @Override
    public String texture(@javax.annotation.Nullable ItemStack stack) {
        int currentMode = ModUtils.getTextureIdx(stack);
        return "dull_knife_" + EmotionColor.values()[currentMode].toString().toLowerCase(Locale.ROOT);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pUsedHand == InteractionHand.OFF_HAND) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int emotionIndex = ModUtils.getTextureIdx(stack);
        emotionIndex = (emotionIndex + 1) % 4;
        ModUtils.setTextureIdx(stack, emotionIndex);
        pPlayer.m_36335_().m_41524_(stack.m_41720_(), 20);
        pLevel.m_247517_(pPlayer, pPlayer.m_20097_(), (SoundEvent)BrutalityModSounds.DULL_KNIFE_ABILITY.get(), SoundSource.PLAYERS);
        if (pLevel.f_46443_) {
            if (stack.m_150930_((Item)BrutalityModItems.DULL_KNIFE_DAGGER.get())) {
                ModUtils.setTextureIdx(stack, emotionIndex);
            }
            EnvironmentColorManager.setColor(EnvironmentColorManager.ColorType.SKY, EmotionColor.byId((int)emotionIndex).primaryColor);
            EnvironmentColorManager.setColor(EnvironmentColorManager.ColorType.FOG, EmotionColor.byId((int)emotionIndex).secondaryColor);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (pAttacker instanceof Player) {
            Player player = (Player)pAttacker;
            pAttacker.m_9236_().m_247517_(player, player.m_20097_(), (SoundEvent)BrutalityModSounds.DULL_KNIFE_STAB.get(), SoundSource.PLAYERS);
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (!ModList.get().isLoaded("bettercombat") && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_9236_().m_5594_(player, player.m_20097_(), (SoundEvent)BrutalityModSounds.DULL_KNIFE_SWING.get(), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.5f, (float)1.0f));
        }
        return super.onEntitySwing(stack, entity);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return super.onEntityItemUpdate(stack, entity);
    }

    public static enum EmotionColor {
        NEUTRAL(new Color(255, 255, 255), new Color(34, 34, 34), (MobEffect)BrutalityModMobEffects.NEUTRAL.get()),
        HAPPY(new Color(255, 226, 0), new Color(255, 48, 251), (MobEffect)BrutalityModMobEffects.HAPPY.get()),
        SAD(new Color(0, 26, 127), new Color(0, 242, 255), (MobEffect)BrutalityModMobEffects.SAD.get()),
        ANGRY(new Color(255, 201, 0), new Color(215, 0, 0), (MobEffect)BrutalityModMobEffects.ANGRY.get());

        public final int primaryColor;
        public final int secondaryColor;
        private final MobEffect effect;

        private EmotionColor(Color primaryColor, Color secondaryColor, MobEffect effect) {
            this.primaryColor = FastColor.ARGB32.m_13660_((int)255, (int)primaryColor.getRed(), (int)primaryColor.getGreen(), (int)primaryColor.getBlue());
            this.secondaryColor = FastColor.ARGB32.m_13660_((int)255, (int)secondaryColor.getRed(), (int)secondaryColor.getGreen(), (int)secondaryColor.getBlue());
            this.effect = effect;
        }

        public static EmotionColor byId(int id) {
            return EmotionColor.values()[Mth.m_14045_((int)id, (int)0, (int)(EmotionColor.values().length - 1))];
        }
    }
}

