/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.goo.brutality.entity.mobs.SummonedStray;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.particle.providers.WaveParticleData;
import net.goo.brutality.registry.BrutalityModParticles;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.core.animation.AnimatableManager;

@Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FrostmourneSword
extends BrutalitySwordItem {
    private static final Map<UUID, Set<UUID>> PLAYER_SUMMONED_STRAYS = new ConcurrentHashMap<UUID, Set<UUID>>();

    public FrostmourneSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @SubscribeEvent
    public static void onStrayDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Stray) {
            Stray stray = (Stray)livingEntity;
            for (Map.Entry entry : PLAYER_SUMMONED_STRAYS.entrySet()) {
                Set summonedStrays = (Set)entry.getValue();
                if (!summonedStrays.remove(stray.m_20148_())) continue;
                if (!summonedStrays.isEmpty()) break;
                PLAYER_SUMMONED_STRAYS.remove(entry.getKey());
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onStrayDespawn(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Stray) {
            Stray stray = (Stray)entity;
            for (Map.Entry entry : PLAYER_SUMMONED_STRAYS.entrySet()) {
                Set summonedStrays = (Set)entry.getValue();
                if (!summonedStrays.remove(stray.m_20148_())) continue;
                if (!summonedStrays.isEmpty()) break;
                PLAYER_SUMMONED_STRAYS.remove(entry.getKey());
                break;
            }
        }
    }

    private static void despawnStraysForPlayer(Player player) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Set summonedStrays = PLAYER_SUMMONED_STRAYS.computeIfAbsent(player.m_20148_(), k -> ConcurrentHashMap.newKeySet());
            HashSet straysToRemove = new HashSet(summonedStrays);
            for (UUID strayUUID : straysToRemove) {
                Entity entity = serverLevel.m_8791_(strayUUID);
                if (!(entity instanceof Stray)) continue;
                entity.m_146870_();
                summonedStrays.remove(strayUUID);
            }
            if (summonedStrays.isEmpty()) {
                PLAYER_SUMMONED_STRAYS.remove(player.m_20148_());
            }
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            FrostmourneSword.despawnStraysForPlayer(player);
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        FrostmourneSword.despawnStraysForPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static void onChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        FrostmourneSword.despawnStraysForPlayer(event.getEntity());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (!pPlayer.m_6144_()) {
            pPlayer.m_36335_().m_41524_(stack.m_41720_(), 80);
            pLevel.m_5594_(pPlayer, pPlayer.m_20097_(), (SoundEvent)BrutalityModSounds.ICE_WAVE.get(), SoundSource.PLAYERS, 1.0f, Mth.m_216267_((RandomSource)pLevel.f_46441_, (float)0.65f, (float)1.0f));
            if (pLevel.m_5776_()) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            this.performSoulrendAttack(pLevel, pPlayer, stack);
        } else if (!pLevel.m_5776_()) {
            pPlayer.m_36335_().m_41524_(stack.m_41720_(), 200);
            this.summonStrayArmy(pLevel, pPlayer, stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void summonStrayArmy(Level level, Player player, ItemStack stack) {
        player.m_36335_().m_41524_(stack.m_41720_(), 20);
        Set summonedStrays = PLAYER_SUMMONED_STRAYS.computeIfAbsent(player.m_20148_(), k -> ConcurrentHashMap.newKeySet());
        int maxStrays = 10;
        int remainingStrays = maxStrays - summonedStrays.size();
        if (remainingStrays <= 0) {
            player.m_5661_((Component)Component.m_237115_((String)"item.frostmourne.stray_army.fail").m_130940_(ChatFormatting.RED), true);
            return;
        }
        int spawnAmt = level.f_46441_.m_216339_(3, 6);
        spawnAmt = Math.min(spawnAmt, remainingStrays);
        for (int i = 0; i < spawnAmt; ++i) {
            stack.m_41622_(1, (LivingEntity)player, pPlayer -> player.m_21166_(EquipmentSlot.MAINHAND));
            SummonedStray stray = new SummonedStray(level, (LivingEntity)player, false);
            if (!level.m_5776_()) {
                stray.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(stray.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
            }
            stray.m_6034_(player.m_20185_() + (double)level.f_46441_.m_216339_(-3, 3), player.m_20186_(), player.m_20189_() + (double)level.f_46441_.m_216339_(-3, 3));
            stray.m_146867_();
            level.m_7967_((Entity)stray);
            summonedStrays.add(stray.m_20148_());
        }
    }

    public void performSoulrendAttack(Level level, Player player, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(new WaveParticleData((ParticleType)BrutalityModParticles.FROSTMOURNE_WAVE.get(), 15.0f, 80), player.m_20185_(), player.m_20186_() + (double)(player.m_20206_() / 3.0f), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            player.m_36335_().m_41524_(stack.m_41720_(), 80);
            List<Entity> entities = ModUtils.applyWaveEffect(serverLevel, player.m_20185_(), player.m_20227_((double)0.33f), player.m_20189_(), Entity.class, new WaveParticleData((ParticleType)BrutalityModParticles.FROSTMOURNE_WAVE.get(), 15.0f, 80), e -> e != player, entity -> {
                entity.m_6469_(player.m_269291_().m_269075_(player), 5.0f);
                entity.m_146917_(40);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_147207_(new MobEffectInstance(MobEffects.f_19597_, 30, 3, false, true), entity);
                }
                player.m_5634_(1.0f);
            });
            player.m_147207_(new MobEffectInstance(MobEffects.f_19600_, entities.size() * 3, entities.size() / 20, false, true), (Entity)player);
            player.m_147207_(new MobEffectInstance(MobEffects.f_19606_, entities.size() * 3, entities.size() / 20, false, true), (Entity)player);
            stack.m_41622_(entities.size() / 2, (LivingEntity)player, pPlayer -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }
}

