/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.sword;

import java.util.List;
import java.util.UUID;
import net.goo.brutality.config.BrutalityCommonConfig;
import net.goo.brutality.entity.projectile.generic.StarEntity;
import net.goo.brutality.item.base.BrutalitySwordItem;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundShootProjectilePacket;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.goo.brutality.util.helpers.ProjectileHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SeventhStarSword
extends BrutalitySwordItem {
    public SeventhStarSword(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.m_6144_()) {
            UUID uuid = pPlayer.m_20148_();
            List nearbyEntities = pLevel.m_45976_(Entity.class, pPlayer.m_20191_().m_82400_(250.0));
            for (Entity entity : nearbyEntities) {
                StarEntity star;
                if (entity instanceof StarEntity && (star = (StarEntity)entity).m_19749_() == pPlayer) {
                    if (!pLevel.m_5776_()) {
                        pLevel.m_254951_((Entity)pPlayer, null, null, star.m_20318_(1.0f).m_82520_(0.0, (double)(star.m_20206_() / 2.0f), 0.0), 1.0f, false, (Boolean)BrutalityCommonConfig.SEVENTH_STAR_GRIEFING.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
                    }
                    star.m_146870_();
                }
                entity.getCapability(BrutalityCapabilities.ENTITY_STAR_COUNT_CAP).ifPresent(cap -> {
                    int starCount = cap.getStarCount(uuid, entity.m_19879_());
                    if (starCount > 0) {
                        for (int i = 0; i < starCount; ++i) {
                            pLevel.m_254951_((Entity)pPlayer, null, null, entity.m_20318_(1.0f).m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0), 1.0f, false, (Boolean)BrutalityCommonConfig.SEVENTH_STAR_GRIEFING.get() != false ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
                        }
                        cap.clearStarCount(uuid, entity.m_19879_());
                        if (!pLevel.m_5776_()) {
                            PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(entity.m_19879_(), entity));
                        }
                    }
                });
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                StarEntity star = new StarEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.STAR_ENTITY.get()), pLevel);
                star.m_37251_((Entity)pPlayer, 0.0f, pPlayer.m_146908_() + (float)(i * 45), 0.0f, 1.0f, 1.0f);
                star.m_5602_((Entity)pPlayer);
                star.m_146884_(pPlayer.m_20318_(1.0f).m_82520_(0.0, (double)pPlayer.m_20192_(), 0.0));
                pLevel.m_7967_((Entity)star);
            }
            pPlayer.m_36335_().m_41524_((Item)this, 20);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_9236_().f_46443_ && !ModList.get().isLoaded("bettercombat")) {
                this.shootTriStar(player);
            }
        }
        return super.onEntitySwing(stack, entity);
    }

    public void shootTriStar(Player player) {
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            for (int i = -15; i <= 15; i += 15) {
                PacketHandler.sendToServer(new ServerboundShootProjectilePacket(BrutalityModEntities.STAR_ENTITY.getId(), 2.5f, false, 0.0f, i));
            }
        } else {
            for (int i = -15; i <= 15; i += 15) {
                ProjectileHelper.shootProjectile(() -> new StarEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.STAR_ENTITY.get()), level), player, level, 2.5f, false, Float.valueOf(0.0f), i);
            }
        }
    }
}

