/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.throwing;

import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class StickyBomb
extends BrutalityThrowingItem {
    public StickyBomb(int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public ResourceLocation getAnimationResourceLocation() {
        return BrutalityThrowingItem.THROW_ANIMATION.DROP.getAnimationResource();
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.BLUNT;
    }

    @Override
    public EntityType<? extends Projectile> getThrownEntity() {
        return (EntityType)BrutalityModEntities.STICKY_BOMB.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pUsedHand) {
        List entities = level.m_45933_(null, player.m_20191_().m_82400_(250.0));
        UUID uuid = player.m_20148_();
        entities.forEach(entity -> {
            net.goo.brutality.entity.projectile.trident.physics_projectile.StickyBomb stickyBomb;
            if (entity instanceof net.goo.brutality.entity.projectile.trident.physics_projectile.StickyBomb && (stickyBomb = (net.goo.brutality.entity.projectile.trident.physics_projectile.StickyBomb)entity).m_19749_() == player) {
                if (!level.m_5776_()) {
                    level.m_254951_((Entity)player, null, null, stickyBomb.m_20318_(1.0f).m_82520_(0.0, (double)(stickyBomb.m_20206_() / 2.0f), 0.0), 1.0f, false, ModUtils.getThrowingWeaponExplosionInteractionFromConfig());
                }
                stickyBomb.m_146870_();
            }
            entity.getCapability(BrutalityCapabilities.ENTITY_STICKY_BOMB_CAP).ifPresent(cap -> {
                int stickyBombCount = cap.getStickyBombCount(uuid, entity.m_19879_());
                if (stickyBombCount <= 0) {
                    return;
                }
                stickyBombCount = Math.min(25, stickyBombCount);
                level.m_254951_((Entity)player, null, null, entity.m_20318_(1.0f).m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0), (float)Math.min(10, stickyBombCount), false, ModUtils.getThrowingWeaponExplosionInteractionFromConfig());
                cap.clearStickyBombCount(uuid, entity.m_19879_());
                if (!level.m_5776_()) {
                    PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(entity.m_19879_(), (Entity)entity));
                }
            });
        });
        return super.m_7203_(level, player, pUsedHand);
    }

    @Override
    public float getInitialThrowVelocity() {
        return 1.0f;
    }
}

