/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.item.weapon.throwing;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.goo.brutality.item.BrutalityCategories;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundShootFromRotationPacket;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.ModAttributes;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class VampireKnives
extends BrutalityThrowingItem {
    UUID OMNIVAMP_UUID = UUID.fromString("7580ebde-96cf-11f0-a1ff-325096b39f47");

    public VampireKnives(int pAttackDamageModifier, float pAttackSpeedModifier, Rarity rarity, List<BrutalityTooltipHelper.ItemDescriptionComponent> descriptionComponents) {
        super(pAttackDamageModifier, pAttackSpeedModifier, rarity, descriptionComponents);
    }

    @Override
    public BrutalityCategories.AttackType getAttackType() {
        return BrutalityCategories.AttackType.PIERCE;
    }

    @Override
    public EntityType<? extends Projectile> getThrownEntity() {
        return (EntityType)BrutalityModEntities.VAMPIRE_KNIFE.get();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            Multimap attributeModifierMultimap = super.getAttributeModifiers(slot, stack);
            builder.putAll(attributeModifierMultimap);
            builder.put((Object)((Attribute)ModAttributes.OMNIVAMP.get()), (Object)new AttributeModifier(this.OMNIVAMP_UUID, "Omnivamp Buff", (double)0.075f, AttributeModifier.Operation.MULTIPLY_BASE));
            return builder.build();
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public float getThrowVelocity(Player player) {
        return (float)Math.min(3.0, player.m_21133_(Attributes.f_22283_));
    }

    @Override
    public void throwProjectile(ItemStack stack, Player player) {
        int quantity = 4;
        quantity += player.m_217043_().m_188501_() < 0.5f ? 1 : 0;
        quantity += player.m_217043_().m_188501_() < 0.25f ? 1 : 0;
        quantity += player.m_217043_().m_188501_() < 0.125f ? 1 : 0;
        quantity += player.m_217043_().m_188501_() < 0.0625f ? 1 : 0;
        float gap = 7.5f;
        for (int i = 0; i < quantity; ++i) {
            float angleOffset = ((float)i - (float)(quantity - 1) / 2.0f) * gap;
            PacketHandler.sendToServer(new ServerboundShootFromRotationPacket(stack, this.getThrownEntity(), player.m_146892_(), player.m_146909_(), player.m_146908_() + (angleOffset += (player.m_217043_().m_188501_() - 0.5f) * 5.0f), this.getThrowVelocity(player), this.getThrowInaccuracy()));
        }
    }
}

