/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.resources.ResourceLocation;

public abstract class BrutalitySpell
implements IBrutalitySpell {
    private final IBrutalitySpell.MagicSchool school;
    private final List<IBrutalitySpell.SpellCategory> categories;
    private final String name;
    private final int baseManaCost;
    private final float baseDamage;
    private final int baseCooldown;
    private final List<BrutalityTooltipHelper.SpellStatComponent> statComponents;
    private final int descriptionCount;
    private static final Map<Class<? extends BrutalitySpell>, Map<BrutalityTooltipHelper.SpellStatComponents, BrutalityTooltipHelper.SpellStatComponent>> SPELL_STATS = new HashMap<Class<? extends BrutalitySpell>, Map<BrutalityTooltipHelper.SpellStatComponents, BrutalityTooltipHelper.SpellStatComponent>>();
    private final int baseCastTime;
    private Map<BrutalityTooltipHelper.SpellStatComponents, BrutalityTooltipHelper.SpellStatComponent> statMap = new HashMap<BrutalityTooltipHelper.SpellStatComponents, BrutalityTooltipHelper.SpellStatComponent>();

    protected BrutalitySpell(IBrutalitySpell.MagicSchool school, List<IBrutalitySpell.SpellCategory> categories, String name, int baseManaCost, float baseDamage, int baseCooldown, int baseCastTime, int descriptionCount, @Nullable List<BrutalityTooltipHelper.SpellStatComponent> statComponents) {
        this.school = school;
        this.categories = categories;
        this.name = name;
        this.baseManaCost = baseManaCost;
        this.baseDamage = baseDamage;
        this.baseCooldown = baseCooldown;
        this.baseCastTime = baseCastTime;
        this.statComponents = statComponents != null ? statComponents : Collections.emptyList();
        this.descriptionCount = descriptionCount;
        if (!this.statComponents.isEmpty()) {
            this.statMap = this.statComponents.stream().collect(Collectors.toMap(BrutalityTooltipHelper.SpellStatComponent::type, Function.identity()));
            SPELL_STATS.put(this.getClass(), this.statMap);
        }
    }

    public String toString() {
        return "BrutalitySpell{school=" + this.school + ", type=" + this.categories + ", name='" + this.name + "', baseManaCost=" + this.baseManaCost + ", baseDamage=" + this.baseDamage + ", baseCooldown=" + this.baseCooldown + ", statComponents=" + this.statComponents + ", descriptionCount=" + this.descriptionCount + "}";
    }

    public static BrutalityTooltipHelper.SpellStatComponent getStat(Class<? extends BrutalitySpell> spellClazz, BrutalityTooltipHelper.SpellStatComponents type) {
        Map<BrutalityTooltipHelper.SpellStatComponents, BrutalityTooltipHelper.SpellStatComponent> statMap = SPELL_STATS.get(spellClazz);
        if (statMap == null) {
            throw new IllegalArgumentException("No stats defined for spell class: " + spellClazz.getSimpleName());
        }
        BrutalityTooltipHelper.SpellStatComponent stat = statMap.get((Object)type);
        if (stat == null) {
            throw new IllegalArgumentException("Stat " + type + " not defined for spell class " + spellClazz.getSimpleName());
        }
        return stat;
    }

    public BrutalityTooltipHelper.SpellStatComponent getStat(BrutalityTooltipHelper.SpellStatComponents type) {
        return this.statMap.get((Object)type);
    }

    @Override
    public IBrutalitySpell.MagicSchool getSchool() {
        return this.school;
    }

    @Override
    public ResourceLocation getIcon() {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/gui/spells/" + this.school.toString().toLowerCase(Locale.ROOT) + "/" + this.name + ".png"));
    }

    @Override
    public String getSpellName() {
        return this.name;
    }

    @Override
    public int getBaseCastTime() {
        return this.baseCastTime;
    }

    @Override
    public float getDamageLevelScaling() {
        return this.getBaseDamage();
    }

    @Override
    public List<BrutalityTooltipHelper.SpellStatComponent> getStatComponents() {
        return this.statComponents;
    }

    @Override
    public int getDescriptionCount() {
        return this.descriptionCount;
    }

    @Override
    public List<IBrutalitySpell.SpellCategory> getCategories() {
        return this.categories;
    }

    @Override
    public float getBaseDamage() {
        return this.baseDamage;
    }

    @Override
    public int getBaseCooldown() {
        return this.baseCooldown;
    }

    @Override
    public int getBaseManaCost() {
        return this.baseManaCost;
    }
}

