/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.network.ClientboundSyncSpellCooldownPacket;
import net.goo.brutality.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpellCooldownTracker {
    private static final Map<UUID, Map<ResourceLocation, CooldownData>> serverCooldowns = new HashMap<UUID, Map<ResourceLocation, CooldownData>>();
    private static final Map<UUID, Map<ResourceLocation, CooldownData>> clientCooldowns = new HashMap<UUID, Map<ResourceLocation, CooldownData>>();
    private static final Map<UUID, Integer> syncTickCounters = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side.isClient()) {
            return;
        }
        Player player = event.player;
        UUID playerId = player.m_20148_();
        Map<ResourceLocation, CooldownData> cooldowns = serverCooldowns.get(playerId);
        if (cooldowns == null) {
            return;
        }
        int tickCounter = syncTickCounters.getOrDefault(playerId, 0) + 1;
        boolean shouldSync = tickCounter >= 10;
        Iterator<Map.Entry<ResourceLocation, CooldownData>> iterator = cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, CooldownData> entry = iterator.next();
            CooldownData data = entry.getValue();
            int remaining = data.remainingTicks - 1;
            int originalTicks = data.originalTicks;
            if (remaining <= 0) {
                iterator.remove();
                if (!shouldSync) continue;
                PacketHandler.sendToPlayer(new ClientboundSyncSpellCooldownPacket(entry.getKey().toString(), 0, 0, 0.0f), (ServerPlayer)player);
                continue;
            }
            float newProgress = (float)(originalTicks - remaining) / (float)originalTicks;
            entry.setValue(new CooldownData(remaining, data.originalTicks, newProgress));
            if (!shouldSync) continue;
            PacketHandler.sendToPlayer(new ClientboundSyncSpellCooldownPacket(entry.getKey().toString(), remaining, data.originalTicks, newProgress), (ServerPlayer)player);
        }
        if (cooldowns.isEmpty()) {
            serverCooldowns.remove(playerId);
            syncTickCounters.remove(playerId);
        } else if (shouldSync) {
            syncTickCounters.put(playerId, 0);
        } else {
            syncTickCounters.put(playerId, tickCounter);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientPlayerTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        UUID playerId = player.m_20148_();
        Map<ResourceLocation, CooldownData> cooldowns = clientCooldowns.get(playerId);
        if (cooldowns == null) {
            return;
        }
        Iterator<Map.Entry<ResourceLocation, CooldownData>> iterator = cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, CooldownData> entry = iterator.next();
            CooldownData data = entry.getValue();
            int remaining = data.remainingTicks - 1;
            int originalTicks = data.originalTicks;
            if (remaining <= 0) {
                iterator.remove();
                continue;
            }
            float newProgress = (float)(originalTicks - remaining) / (float)originalTicks;
            entry.setValue(new CooldownData(remaining, data.originalTicks, newProgress));
        }
        if (cooldowns.isEmpty()) {
            clientCooldowns.remove(playerId);
        }
    }

    public static void setCooldown(Player player, IBrutalitySpell spell, int spellLevel) {
        int cooldownTicks = IBrutalitySpell.getActualCooldown(player, spell, spellLevel);
        if (cooldownTicks <= 0) {
            return;
        }
        ResourceLocation spellId = SpellCooldownTracker.getSpellId(spell);
        CooldownData data = new CooldownData(cooldownTicks, cooldownTicks, 0.0f);
        if (!player.m_9236_().m_5776_()) {
            Map cooldowns = serverCooldowns.computeIfAbsent(player.m_20148_(), k -> new HashMap());
            cooldowns.put(spellId, data);
            PacketHandler.sendToPlayer(new ClientboundSyncSpellCooldownPacket(spellId.toString(), cooldownTicks, cooldownTicks, 0.0f), (ServerPlayer)player);
        } else {
            clientCooldowns.computeIfAbsent(player.m_20148_(), k -> new HashMap()).put(spellId, data);
        }
    }

    public static void resetCooldowns(Player player) {
        UUID playerId = player.m_20148_();
        if (!player.m_9236_().m_5776_()) {
            Map<ResourceLocation, CooldownData> cooldowns = serverCooldowns.get(playerId);
            if (cooldowns != null) {
                cooldowns.keySet().forEach(spellId -> PacketHandler.sendToPlayer(new ClientboundSyncSpellCooldownPacket(spellId.toString(), 0, 0, 0.0f), (ServerPlayer)player));
                serverCooldowns.remove(playerId);
            }
        } else {
            clientCooldowns.remove(playerId);
        }
    }

    public static boolean isOnCooldown(Player player, IBrutalitySpell spell) {
        ResourceLocation spellId = SpellCooldownTracker.getSpellId(spell);
        Map<UUID, Map<ResourceLocation, CooldownData>> cooldownMap = player.m_9236_().m_5776_() ? clientCooldowns : serverCooldowns;
        return cooldownMap.getOrDefault(player.m_20148_(), Collections.emptyMap()).containsKey(spellId);
    }

    public static int getRemainingTicks(Player player, IBrutalitySpell spell) {
        ResourceLocation spellId = SpellCooldownTracker.getSpellId(spell);
        Map<UUID, Map<ResourceLocation, CooldownData>> cooldownMap = player.m_9236_().m_5776_() ? clientCooldowns : serverCooldowns;
        CooldownData data = (CooldownData)cooldownMap.getOrDefault(player.m_20148_(), Collections.emptyMap()).get(spellId);
        return data != null ? data.remainingTicks : 0;
    }

    public static float getCooldownProgress(Player player, IBrutalitySpell spell) {
        ResourceLocation spellId = SpellCooldownTracker.getSpellId(spell);
        CooldownData data = (CooldownData)clientCooldowns.getOrDefault(player.m_20148_(), Collections.emptyMap()).get(spellId);
        return data != null ? Math.max(0.0f, Math.min(1.0f, data.progress)) : 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateCooldownClient(String spellId, int remaining, int original, float progress) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ResourceLocation id = ResourceLocation.parse((String)spellId);
            UUID playerId = Minecraft.m_91087_().f_91074_.m_20148_();
            if (remaining > 0) {
                float clampedProgress = Math.max(0.0f, Math.min(1.0f, progress));
                clientCooldowns.computeIfAbsent(playerId, k -> new HashMap()).put(id, new CooldownData(remaining, original, clampedProgress));
            } else {
                clientCooldowns.getOrDefault(playerId, Collections.emptyMap()).remove(id);
            }
        }
    }

    private static ResourceLocation getSpellId(IBrutalitySpell spell) {
        return ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)spell.getSpellName().toLowerCase(Locale.ROOT));
    }

    public record CooldownData(int remainingTicks, int originalTicks, float progress) {
    }
}

