/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic.spells.brimwielder;

import java.util.Iterator;
import java.util.List;
import net.goo.brutality.entity.base.BrutalityRay;
import net.goo.brutality.entity.spells.brimwielder.ExtinctionEntity;
import net.goo.brutality.event.forge.DelayedTaskScheduler;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExtinctionSpell
extends BrutalitySpell {
    public ExtinctionSpell() {
        super(IBrutalitySpell.MagicSchool.BRIMWIELDER, List.of(IBrutalitySpell.SpellCategory.CONTINUOUS, IBrutalitySpell.SpellCategory.AOE), "extinction", 1, 1.0f, 200, 0, 1, List.of(new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.RANGE, 25.0f, 5.0f, Float.valueOf(25.0f), Float.valueOf(100.0f)), new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.PIERCE, 25.0f, 5.0f, Float.valueOf(25.0f), Float.valueOf(100.0f)), new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.SIZE, 0.5f, 0.25f, Float.valueOf(0.5f), Float.valueOf(5.0f))));
    }

    @Override
    public float getDamageLevelScaling() {
        return 0.5f;
    }

    @Override
    public float getManaCostLevelScaling() {
        return 0.25f;
    }

    @Override
    public int getCooldownLevelScaling() {
        return 5;
    }

    @Override
    public boolean onCastTick(Player player, ItemStack stack, int spellLevel) {
        Entity entity = this.getSpellEntity(player.m_9236_(), player);
        if (entity instanceof ExtinctionEntity) {
            ExtinctionEntity extinctionEntity = (ExtinctionEntity)entity;
            float range = this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.RANGE));
            float radius = this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.SIZE)) / 2.0f;
            int pierce = (int)this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.PIERCE));
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ModUtils.RayData<LivingEntity> rayData = ModUtils.getEntitiesInRay(LivingEntity.class, (LivingEntity)player, range, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, radius, e -> e != player, pierce, null);
                extinctionEntity.setDataMaxLength(rayData.distance() - 2);
                if (rayData.entityList() == null) {
                    return false;
                }
                for (LivingEntity target : rayData.entityList()) {
                    target.f_19802_ = 0;
                    target.m_6469_(target.m_269291_().m_269104_((Entity)player, null), this.getFinalDamage((Entity)player, spellLevel));
                }
                Vec3 endPos = rayData.endPos();
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TerramityModParticleTypes.STYGIAN_PARTICLE.get()), endPos.f_82479_, endPos.f_82480_, endPos.f_82481_, 5, 1.0, 1.0, 1.0, 0.0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onStartCast(Player player, ItemStack stack, int spellLevel) {
        if (this.getSpellEntity(player.m_9236_(), player) == null) {
            ExtinctionEntity extinctionEntity = new ExtinctionEntity((EntityType<? extends BrutalityRay>)((EntityType)BrutalityModEntities.EXTINCTION_ENTITY.get()), player.m_9236_());
            extinctionEntity.m_5602_((Entity)player);
            extinctionEntity.m_146884_(player.m_146892_().m_82549_(player.m_20154_().m_82490_(3.0)));
            extinctionEntity.setSpellLevel(spellLevel);
            player.m_9236_().m_7967_((Entity)extinctionEntity);
            return true;
        }
        return false;
    }

    @Override
    public void onEndCast(Player player, ItemStack stack, int spellLevel) {
        super.onEndCast(player, stack, spellLevel);
        Entity entity = this.getSpellEntity(player.m_9236_(), player);
        if (entity instanceof ExtinctionEntity) {
            ExtinctionEntity extinctionEntity = (ExtinctionEntity)entity;
            extinctionEntity.triggerAnim("controller", "despawn");
            DelayedTaskScheduler.queueServerWork(player.m_9236_(), 20, () -> ((ExtinctionEntity)extinctionEntity).m_146870_());
        }
    }

    private Entity getSpellEntity(Level level, Player player) {
        Iterator iterator = level.m_6443_(ExtinctionEntity.class, player.m_20191_().m_82400_(25.0), e -> e.m_19749_() == player).iterator();
        if (iterator.hasNext()) {
            ExtinctionEntity entity = (ExtinctionEntity)iterator.next();
            return entity;
        }
        return null;
    }
}

