/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic.spells.cosmic;

import java.util.List;
import net.goo.brutality.entity.spells.cosmic.CosmicCataclysmEntity;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CosmicCataclysmSpell
extends BrutalitySpell {
    public CosmicCataclysmSpell() {
        super(IBrutalitySpell.MagicSchool.COSMIC, List.of(IBrutalitySpell.SpellCategory.CHANNELLING, IBrutalitySpell.SpellCategory.AOE), "cosmic_cataclysm", 100, 10.0f, 100, 20, 1, List.of(new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.RANGE, 15.0f, 5.0f, Float.valueOf(0.0f), Float.valueOf(100.0f)), new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.SIZE, 3.0f, 1.0f, Float.valueOf(3.0f), Float.valueOf(50.0f))));
    }

    @Override
    public float getDamageLevelScaling() {
        return 3.0f;
    }

    @Override
    public float getManaCostLevelScaling() {
        return 5.0f;
    }

    @Override
    public int getCooldownLevelScaling() {
        return 2;
    }

    @Override
    public int getCastTimeLevelScaling() {
        return 3;
    }

    @Override
    public boolean onStartCast(Player player, ItemStack stack, int spellLevel) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = ModUtils.getBlockLookingAt(player, false, this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.RANGE)));
            if (blockPos == null) {
                return false;
            }
            Vec3 targetPos = blockPos.m_252807_();
            Vec3 spawnPos = targetPos.m_82520_(0.0, (double)(Math.min(50, spellLevel) * 10), 0.0);
            CosmicCataclysmEntity spellEntity = new CosmicCataclysmEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.COSMIC_CATACLYSM_ENTITY.get()), (Level)serverLevel);
            spellEntity.setSpellLevel(spellLevel);
            spellEntity.m_146884_(spawnPos);
            spellEntity.m_5602_((Entity)player);
            serverLevel.m_7967_((Entity)spellEntity);
        }
        return true;
    }
}

