/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.magic.spells.voidwalker;

import java.util.List;
import net.goo.brutality.magic.BrutalitySpell;
import net.goo.brutality.magic.IBrutalitySpell;
import net.goo.brutality.util.ModUtils;
import net.goo.brutality.util.helpers.BrutalityTooltipHelper;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VoidWalkSpell
extends BrutalitySpell {
    public VoidWalkSpell() {
        super(IBrutalitySpell.MagicSchool.VOIDWALKER, List.of(IBrutalitySpell.SpellCategory.INSTANT, IBrutalitySpell.SpellCategory.TARGET, IBrutalitySpell.SpellCategory.UTILITY), "void_walk", 40, 0.0f, 160, 0, 1, List.of(new BrutalityTooltipHelper.SpellStatComponent(BrutalityTooltipHelper.SpellStatComponents.RANGE, 20.0f, 10.0f, Float.valueOf(0.0f), Float.valueOf(250.0f))));
    }

    @Override
    public int getCooldownLevelScaling() {
        return -10;
    }

    @Override
    public boolean onStartCast(Player player, ItemStack stack, int spellLevel) {
        float baseRange = this.getFinalStat(spellLevel, this.getStat(BrutalityTooltipHelper.SpellStatComponents.RANGE));
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = ModUtils.getBlockLookingAt(player, false, baseRange);
            if (blockPos == null) {
                return false;
            }
            BlockPos validPos = this.getValidPos((Level)serverLevel, blockPos, 3);
            if (validPos == null) {
                return false;
            }
            Vec3 startPos = player.m_20318_(1.0f);
            Vec3 blockCenter = validPos.m_252807_();
            player.m_6021_(blockCenter.m_7096_(), (double)validPos.m_123342_(), blockCenter.m_7094_());
            Vec3 endPos = validPos.m_252807_();
            Vec3 direction = startPos.m_82505_(endPos);
            double distance = direction.m_82553_();
            Vec3 unitDir = direction.m_82541_();
            for (double d = 0.0; d < distance; d += 0.5) {
                Vec3 intervalPos = new Vec3(unitDir.m_252839_()).m_82490_(d);
                Vec3 particlePos = startPos.m_82549_(intervalPos);
                ModUtils.sendParticles(serverLevel, (SimpleParticleType)TerramityModParticleTypes.ANTIMATTER.get(), true, particlePos, 0.05, 0.05, 0.05, 1, 0.0);
            }
            ModUtils.sendParticles(serverLevel, (SimpleParticleType)TerramityModParticleTypes.ANTIMATTER.get(), true, (Entity)player, 0.0, 0.0, 0.0, 20, 0.0);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TerramityModParticleTypes.ANTIMATTER.get()), player.m_20185_(), player.m_20186_(), player.m_20189_(), 20, 1.0, 1.0, 1.0, 0.0);
            serverLevel.m_5594_(null, BlockPos.m_274446_((Position)endPos), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 20, 0, false, false, true));
        }
        return true;
    }

    private BlockPos getValidPos(Level level, BlockPos basePos, int distance) {
        for (int i = 0; i < distance; ++i) {
            BlockPos floorPos = basePos.m_6630_(i);
            if (!ModUtils.isStandable((BlockGetter)level, floorPos)) continue;
            BlockPos air1 = floorPos.m_7494_();
            BlockPos air2 = air1.m_7494_();
            if (!level.m_8055_(air1).m_60795_() || !level.m_8055_(air2).m_60795_()) continue;
            return air1;
        }
        return null;
    }
}

