/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import java.util.List;
import java.util.Locale;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.util.SealUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    private void addHoverText(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced, CallbackInfo ci) {
        SealUtils.SEAL_TYPE sealType = SealUtils.getSealType(pStack);
        if (sealType != null && sealType.showDescription().booleanValue()) {
            String key = "brutality." + sealType.name().toLowerCase(Locale.ROOT) + "_seal";
            pTooltipComponents.add((Component)Component.m_237119_());
            pTooltipComponents.add((Component)Component.m_237115_((String)key));
            if (pStack.m_204117_(Tags.Items.ARMORS) || pStack.m_41720_() instanceof ArmorItem) {
                pTooltipComponents.add((Component)Component.m_237115_((String)(key + ".armor")));
            } else if (pStack.m_41720_() instanceof BrutalityThrowingItem || pStack.m_41720_() instanceof BowItem || pStack.m_204117_(Tags.Items.TOOLS_BOWS)) {
                pTooltipComponents.add((Component)Component.m_237115_((String)(key + ".projectile")));
            } else {
                pTooltipComponents.add((Component)Component.m_237115_((String)(key + ".item")));
            }
            if (pStack.m_41793_() && (6 & ItemStack.TooltipPart.ENCHANTMENTS.m_41809_()) == 0) {
                pTooltipComponents.add((Component)Component.m_237119_());
            }
        }
    }
}

