/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mixin;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import net.goo.brutality.event.forge.ForgePlayerStateHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    public ServerPlayerMixin(Level pLevel, BlockPos pPos, float pYRot, GameProfile pGameProfile) {
        super(pLevel, pPos, pYRot, pGameProfile);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void saveCooldowns(CompoundTag tag, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        ItemCooldowns itemCooldowns = player.m_36335_();
        CompoundTag cooldownTag = new CompoundTag();
        cooldownTag.m_128405_("tickCount", itemCooldowns.f_41516_);
        CompoundTag mapTag = new CompoundTag();
        for (Map.Entry entry : itemCooldowns.f_41515_.entrySet()) {
            if (!ForgePlayerStateHandler.cdPersistItems.get().contains(entry.getKey())) continue;
            CompoundTag cooldownInstanceTag = new CompoundTag();
            cooldownInstanceTag.m_128405_("startTime", ((ItemCooldowns.CooldownInstance)entry.getValue()).f_41533_);
            cooldownInstanceTag.m_128405_("endTime", ((ItemCooldowns.CooldownInstance)entry.getValue()).f_41534_);
            mapTag.m_128365_(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)((Item)entry.getKey()))), (Tag)cooldownInstanceTag);
        }
        cooldownTag.m_128365_("cooldowns", (Tag)mapTag);
        tag.m_128365_("BrutalityCooldowns", (Tag)cooldownTag);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void loadCooldowns(CompoundTag tag, CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        ItemCooldowns itemCooldowns = player.m_36335_();
        if (tag.m_128441_("BrutalityCooldowns")) {
            CompoundTag cooldownTag = tag.m_128469_("BrutalityCooldowns");
            itemCooldowns.f_41516_ = cooldownTag.m_128451_("tickCount");
            CompoundTag mapTag = cooldownTag.m_128469_("cooldowns");
            itemCooldowns.f_41515_.clear();
            for (String itemKey : mapTag.m_128431_()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemKey));
                if (item == null) continue;
                CompoundTag cooldownInstanceTag = mapTag.m_128469_(itemKey);
                int startTime = cooldownInstanceTag.m_128451_("startTime");
                int endTime = cooldownInstanceTag.m_128451_("endTime");
                itemCooldowns.f_41515_.put(item, new ItemCooldowns.CooldownInstance(startTime, endTime));
            }
        }
    }
}

