/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.mob_effect;

import java.util.UUID;
import net.goo.brutality.registry.BrutalityModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EnragedEffect
extends MobEffect {
    public static final UUID ENRAGED_AD_UUID = UUID.fromString("e66b00e4-25b0-42df-bbc2-ba95445c2bf5");
    public static final UUID ENRAGED_ARMOR_UUID = UUID.fromString("18918f9b-66f4-4190-8a2d-f8cc9c884ffb");
    public static final UUID ENRAGED_AS_UUID = UUID.fromString("45783c22-2ed9-47fe-a46e-07f6fb8d0d37");
    public static final UUID ENRAGED_MS_UUID = UUID.fromString("4e0f449b-3c0f-445b-b894-6b3dec2c4b03");

    public EnragedEffect(MobEffectCategory category, int color) {
        super(category, color);
        this.m_19472_(Attributes.f_22279_, ENRAGED_MS_UUID.toString(), 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22283_, ENRAGED_AS_UUID.toString(), 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22281_, ENRAGED_AD_UUID.toString(), 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.m_19472_(Attributes.f_22284_, ENRAGED_ARMOR_UUID.toString(), 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)BrutalityModParticles.ENRAGED_PARTICLE.get()), entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, 0.5, 0.5, 0.5, 0.0);
        }
    }

    public double m_7048_(int amplifier, @NotNull AttributeModifier modifier) {
        UUID modifierId = modifier.m_22209_();
        if (modifierId.equals(ENRAGED_MS_UUID)) {
            return 0.2 + 0.1 * (double)amplifier;
        }
        if (modifierId.equals(ENRAGED_AS_UUID)) {
            return 0.2 + 0.1 * (double)amplifier;
        }
        if (modifierId.equals(ENRAGED_AD_UUID)) {
            return 0.5 + 0.05 * (double)amplifier;
        }
        if (modifierId.equals(ENRAGED_ARMOR_UUID)) {
            return Math.min(-1.0 + 0.1 * (double)amplifier, 0.0);
        }
        return 0.0;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 5 == 0;
    }
}

