/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.util.helpers.EnvironmentColorManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.FastColor;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEnvironmentColorManagerPacket {
    private final EnvironmentColorManager.ColorType type;
    private final int r;
    private final int g;
    private final int b;
    private final boolean isReset;

    public ClientboundEnvironmentColorManagerPacket(EnvironmentColorManager.ColorType type, int r, int g, int b, boolean isReset) {
        this.type = type;
        this.r = r;
        this.g = g;
        this.b = b;
        this.isReset = isReset;
    }

    public ClientboundEnvironmentColorManagerPacket(FriendlyByteBuf buf) {
        this.type = (EnvironmentColorManager.ColorType)buf.m_130066_(EnvironmentColorManager.ColorType.class);
        this.r = buf.readInt();
        this.g = buf.readInt();
        this.b = buf.readInt();
        this.isReset = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.writeInt(this.r);
        buf.writeInt(this.g);
        buf.writeInt(this.b);
        buf.writeBoolean(this.isReset);
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (this.isReset) {
                EnvironmentColorManager.resetAllColors();
            } else {
                EnvironmentColorManager.setColor(this.type, FastColor.ARGB32.m_13660_((int)255, (int)this.r, (int)this.g, (int)this.b));
            }
        });
        context.get().setPacketHandled(true);
    }
}

