/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientboundExactParticlePacket {
    public final double x;
    public final double y;
    public final double z;
    public final ParticleOptions particle;

    public ClientboundExactParticlePacket(double pX, double pY, double pZ, ParticleOptions particle) {
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.particle = particle;
    }

    public ClientboundExactParticlePacket(FriendlyByteBuf pBuffer) {
        ParticleType type = (ParticleType)pBuffer.readRegistryIdSafe(ParticleType.class);
        this.x = pBuffer.readDouble();
        this.y = pBuffer.readDouble();
        this.z = pBuffer.readDouble();
        this.particle = this.readParticle(pBuffer, type);
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)this.particle.m_6012_());
        pBuffer.writeDouble(this.x);
        pBuffer.writeDouble(this.y);
        pBuffer.writeDouble(this.z);
        this.particle.m_7711_(pBuffer);
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf pBuffer, ParticleType<T> pParticleType) {
        return (T)pParticleType.m_123743_().m_6507_(pParticleType, pBuffer);
    }

    public static void handle(ClientboundExactParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level patt2114$temp;
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null && (patt2114$temp = sender.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt2114$temp;
                serverLevel.m_8767_(packet.particle, packet.x, packet.y, packet.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

