/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.Brutality;
import net.goo.brutality.client.ClientAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientboundParticlePacket {
    public final float x;
    public final float y;
    public final float z;
    public final float xDist;
    public final float yDist;
    public final float zDist;
    public final float xSpeed;
    public final float ySpeed;
    public final float zSpeed;
    public final int count;
    public final boolean overrideLimiter;
    public final ParticleOptions particle;

    public <T extends ParticleOptions> ClientboundParticlePacket(T pParticle, boolean pOverrideLimiter, float pX, float pY, float pZ, float pXDist, float pYDist, float pZDist, float xSpeed, float ySpeed, float zSpeed, int pCount) {
        this.particle = pParticle;
        this.overrideLimiter = pOverrideLimiter;
        this.x = pX;
        this.y = pY;
        this.z = pZ;
        this.xDist = pXDist;
        this.yDist = pYDist;
        this.zDist = pZDist;
        this.xSpeed = xSpeed;
        this.ySpeed = ySpeed;
        this.zSpeed = zSpeed;
        this.count = pCount;
    }

    public ClientboundParticlePacket(FriendlyByteBuf pBuffer) {
        ParticleType particletype = (ParticleType)pBuffer.readRegistryIdSafe(ParticleType.class);
        this.overrideLimiter = pBuffer.readBoolean();
        this.x = pBuffer.readFloat();
        this.y = pBuffer.readFloat();
        this.z = pBuffer.readFloat();
        this.xDist = pBuffer.readFloat();
        this.yDist = pBuffer.readFloat();
        this.zDist = pBuffer.readFloat();
        this.xSpeed = pBuffer.readFloat();
        this.ySpeed = pBuffer.readFloat();
        this.zSpeed = pBuffer.readFloat();
        this.count = pBuffer.readInt();
        this.particle = this.readParticle(pBuffer, particletype);
    }

    public void write(FriendlyByteBuf pBuffer) {
        pBuffer.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, (Object)this.particle.m_6012_());
        pBuffer.writeBoolean(this.overrideLimiter);
        pBuffer.writeFloat(this.x);
        pBuffer.writeFloat(this.y);
        pBuffer.writeFloat(this.z);
        pBuffer.writeFloat(this.xDist);
        pBuffer.writeFloat(this.yDist);
        pBuffer.writeFloat(this.zDist);
        pBuffer.writeFloat(this.xSpeed);
        pBuffer.writeFloat(this.ySpeed);
        pBuffer.writeFloat(this.zSpeed);
        pBuffer.writeInt(this.count);
        this.particle.m_7711_(pBuffer);
    }

    private <T extends ParticleOptions> T readParticle(FriendlyByteBuf pBuffer, ParticleType<T> pParticleType) {
        try {
            return (T)pParticleType.m_123743_().m_6507_(pParticleType, pBuffer);
        }
        catch (Exception e) {
            Brutality.LOGGER.error("Failed to deserialize particle type {}: {}", pParticleType, (Object)e.getMessage());
            throw e;
        }
    }

    public static void handle(ClientboundParticlePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientAccess.spawnParticles(packet));
        ctx.get().setPacketHandled(true);
    }
}

