/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.goo.brutality.client.ClientAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncItemCooldownPacket {
    private final Map<Item, ItemCooldowns.CooldownInstance> cooldowns;
    private final int tickCount;

    public ClientboundSyncItemCooldownPacket(Map<Item, ItemCooldowns.CooldownInstance> cooldowns, int tickCount) {
        this.cooldowns = new HashMap<Item, ItemCooldowns.CooldownInstance>(cooldowns);
        this.tickCount = tickCount;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.cooldowns.size());
        buf.m_130130_(this.tickCount);
        for (Map.Entry<Item, ItemCooldowns.CooldownInstance> entry : this.cooldowns.entrySet()) {
            buf.m_130055_(entry.getKey().m_7968_());
            buf.m_130130_(entry.getValue().f_41533_);
            buf.m_130130_(entry.getValue().f_41534_);
        }
    }

    public static ClientboundSyncItemCooldownPacket decode(FriendlyByteBuf buf) {
        HashMap<Item, ItemCooldowns.CooldownInstance> cooldowns = new HashMap<Item, ItemCooldowns.CooldownInstance>();
        int size = buf.m_130242_();
        int tickCount = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = buf.m_130267_();
            Item item = stack.m_41720_();
            int startTime = buf.m_130242_();
            int endTime = buf.m_130242_();
            cooldowns.put(item, new ItemCooldowns.CooldownInstance(startTime, endTime));
        }
        return new ClientboundSyncItemCooldownPacket(cooldowns, tickCount);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientAccess.syncItemCooldowns(this.cooldowns, this.tickCount));
        ctx.get().setPacketHandled(true);
    }
}

