/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.magic.SpellCooldownTracker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncSpellCooldownPacket {
    private final String spellId;
    private final int remaining;
    private final int original;
    private final float progress;

    public ClientboundSyncSpellCooldownPacket(String spellId, int remaining, int original, float progress) {
        this.spellId = spellId;
        this.remaining = remaining;
        this.original = original;
        this.progress = progress;
    }

    public ClientboundSyncSpellCooldownPacket(FriendlyByteBuf buf) {
        this.spellId = buf.m_130277_();
        this.remaining = buf.readInt();
        this.original = buf.readInt();
        this.progress = buf.readFloat();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.spellId);
        buf.writeInt(this.remaining);
        buf.writeInt(this.original);
        buf.writeFloat(this.progress);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SpellCooldownTracker.updateCooldownClient(this.spellId, this.remaining, this.original, this.progress));
        ctx.get().setPacketHandled(true);
    }
}

