/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.network.ClientboundSyncCapabilitiesPacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.registry.BrutalityCapabilities;
import net.goo.brutality.registry.BrutalityModMobEffects;
import net.goo.brutality.registry.ModAttributes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraftforge.network.NetworkEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class ServerboundActivateRagePacket {
    public ServerboundActivateRagePacket() {
    }

    public ServerboundActivateRagePacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public static void handle(ServerboundActivateRagePacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            CuriosApi.getCuriosInventory((LivingEntity)sender).ifPresent(handler -> sender.getCapability(BrutalityCapabilities.PLAYER_RAGE_CAP).ifPresent(cap -> {
                int maxRage = (int)sender.m_21133_((Attribute)ModAttributes.MAX_RAGE.get());
                if (cap.rageValue() >= (float)maxRage) {
                    AttributeInstance rageLevelAttr;
                    int duration = 40;
                    int rageLevel = (int)Math.floor(cap.rageValue() / 100.0f);
                    AttributeInstance rageTimeAttr = sender.m_21051_((Attribute)ModAttributes.RAGE_TIME_MULTIPLIER.get());
                    if (rageTimeAttr != null) {
                        duration = (int)((double)duration * rageTimeAttr.m_22135_());
                    }
                    if ((rageLevelAttr = sender.m_21051_((Attribute)ModAttributes.RAGE_LEVEL.get())) != null) {
                        rageLevel += (int)rageLevelAttr.m_22135_();
                    }
                    sender.m_7292_(new MobEffectInstance((MobEffect)BrutalityModMobEffects.ENRAGED.get(), duration, rageLevel, false, true));
                    cap.setRageValue(0.0f);
                    sender.m_9236_().m_6263_(null, sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                cap.setRageValue(Math.min(cap.rageValue(), (float)maxRage));
                PacketHandler.sendToAllClients(new ClientboundSyncCapabilitiesPacket(sender.m_19879_(), (Entity)sender));
            }));
        });
        context.setPacketHandled(true);
    }
}

