/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.item.weapon.tome.BaseMagicTome;
import net.goo.brutality.magic.SpellStorage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundChangeSpellPacket {
    private final int direction;
    private final int index;

    public ServerboundChangeSpellPacket(int direction, int index) {
        this.direction = direction;
        this.index = index;
    }

    public ServerboundChangeSpellPacket(FriendlyByteBuf buf) {
        this.direction = buf.readInt();
        this.index = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.direction);
        buf.writeInt(this.index);
    }

    public static void handle(ServerboundChangeSpellPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.m_150109_().m_8020_(packet.index)).m_41720_() instanceof BaseMagicTome) {
                SpellStorage.cycleSelectedSpell(stack, packet.direction);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

