/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.goo.brutality.network.ClientboundPlayerAnimationPacket;
import net.goo.brutality.network.PacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundPlayerAnimationPacket {
    UUID playerId;
    ResourceLocation animation;
    boolean mirrored;
    float speed;

    public ServerboundPlayerAnimationPacket(UUID playerId, ResourceLocation animation, boolean mirrored, float speed) {
        this.playerId = playerId;
        this.animation = animation;
        this.mirrored = mirrored;
        this.speed = speed;
    }

    public ServerboundPlayerAnimationPacket(FriendlyByteBuf buf) {
        this.playerId = buf.m_130259_();
        this.animation = buf.m_130281_();
        this.mirrored = buf.readBoolean();
        this.speed = buf.readFloat();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerId);
        buf.m_130085_(this.animation);
        buf.writeBoolean(this.mirrored);
        buf.writeFloat(this.speed);
    }

    public static void handle(ServerboundPlayerAnimationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            ServerLevel level = sender.m_284548_();
            for (ServerPlayer player : level.m_6907_()) {
                if (player == ((NetworkEvent.Context)ctx.get()).getSender()) continue;
                PacketHandler.sendToPlayer(new ClientboundPlayerAnimationPacket(packet.playerId, packet.animation, packet.mirrored, packet.speed), player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

