/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.goo.brutality.util.helpers.ProjectileHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerboundShootProjectilePacket {
    private final ResourceLocation projectileId;
    private final float vel;
    private final float delta;
    private final boolean random;
    private final int angleOffset;

    public ServerboundShootProjectilePacket(ResourceLocation projectileId, float vel, boolean random, float delta, int angleOffset) {
        this.projectileId = projectileId;
        this.vel = vel;
        this.random = random;
        this.delta = delta;
        this.angleOffset = angleOffset;
    }

    public ServerboundShootProjectilePacket(FriendlyByteBuf buf) {
        this.projectileId = buf.m_130281_();
        this.vel = buf.readFloat();
        this.random = buf.readBoolean();
        this.delta = buf.readFloat();
        this.angleOffset = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.projectileId);
        buf.writeFloat(this.vel);
        buf.writeBoolean(this.random);
        buf.writeFloat(this.delta);
        buf.writeInt(this.angleOffset);
    }

    public static void handle(ServerboundShootProjectilePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender == null) {
                return;
            }
            Level level = sender.m_9236_();
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(packet.projectileId);
            ProjectileHelper.shootProjectile(() -> (Projectile)entityType.m_20615_(level), (Player)sender, level, packet.vel, packet.random, Float.valueOf(packet.delta), packet.angleOffset);
        });
        ctx.get().setPacketHandled(true);
    }
}

