/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;

public class ServerboundTriggerAnimationPacket {
    private final ItemStack stack;
    private final String controllerName;
    private final String animationName;
    private final long id;

    public ServerboundTriggerAnimationPacket(ItemStack stack, long id, String controllerName, String animationName) {
        this.stack = stack;
        this.id = id;
        this.controllerName = controllerName;
        this.animationName = animationName;
    }

    public ServerboundTriggerAnimationPacket(FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.id = buf.readLong();
        this.controllerName = buf.m_130277_();
        this.animationName = buf.m_130277_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeLong(this.id);
        buf.m_130070_(this.controllerName);
        buf.m_130070_(this.animationName);
    }

    public static void handle(ServerboundTriggerAnimationPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            assert (sender != null);
            if (sender.m_9236_() instanceof ServerLevel) {
                ((SingletonGeoAnimatable)sender.m_21205_().m_41720_()).triggerAnim((Entity)sender, GeoItem.getOrAssignId((ItemStack)sender.m_21205_(), (ServerLevel)((ServerLevel)sender.m_9236_())), packet.controllerName, packet.animationName);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

