/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util;

import net.bettercombat.api.client.BetterCombatClientEvents;
import net.goo.brutality.item.base.BrutalityThrowingItem;
import net.goo.brutality.item.weapon.hammer.AtomicJudgementHammer;
import net.goo.brutality.item.weapon.sword.ChallengerDeepSword;
import net.goo.brutality.item.weapon.sword.ExobladeSword;
import net.goo.brutality.item.weapon.sword.MarianasTrenchSword;
import net.goo.brutality.item.weapon.sword.MurasamaSword;
import net.goo.brutality.item.weapon.sword.SeventhStarSword;
import net.goo.brutality.item.weapon.sword.SupernovaSword;
import net.goo.brutality.item.weapon.sword.TerraBladeSword;
import net.goo.brutality.item.weapon.sword.TerratomereSword;
import net.goo.brutality.network.ClientboundExactParticlePacket;
import net.goo.brutality.network.PacketHandler;
import net.goo.brutality.network.ServerboundTriggerAnimationPacket;
import net.goo.brutality.particle.providers.FlatParticleData;
import net.goo.brutality.registry.BrutalityModParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import software.bernie.geckolib.animatable.GeoItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BetterCombatIntegration {
    public static void register() {
        BetterCombatClientEvents.ATTACK_START.register((player, hand) -> {
            Level patt1123$temp = player.m_9236_();
            if (!(patt1123$temp instanceof ClientLevel)) {
                return;
            }
            ClientLevel level = (ClientLevel)patt1123$temp;
            if (hand == null) {
                return;
            }
            ItemStack stack = hand.isOffHand() ? player.m_21206_() : player.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof TerraBladeSword) {
                TerraBladeSword terraBladeSword = (TerraBladeSword)item;
                terraBladeSword.performTerraBeam(stack, (Player)player);
            } else if (item instanceof TerratomereSword) {
                TerratomereSword terratomereSword = (TerratomereSword)item;
                terratomereSword.performTerraBeam(stack, (Player)player);
            } else if (item instanceof ExobladeSword) {
                ExobladeSword exobladeSword = (ExobladeSword)item;
                exobladeSword.performExobladeBeam(stack, (Player)player);
            } else if (item instanceof SeventhStarSword) {
                SeventhStarSword seventhStarSword = (SeventhStarSword)item;
                seventhStarSword.shootTriStar((Player)player);
            } else if (item instanceof MarianasTrenchSword) {
                MarianasTrenchSword marianasTrenchSword = (MarianasTrenchSword)item;
                marianasTrenchSword.performMarianasTrenchAttack(stack, (Player)player);
            } else if (item instanceof ChallengerDeepSword) {
                ChallengerDeepSword challengerDeepSword = (ChallengerDeepSword)item;
                challengerDeepSword.performChallengerDeepAttack(stack, (Player)player);
            } else if (item instanceof SupernovaSword) {
                if (hand.combo().current() == 2) {
                    PacketHandler.sendToServer(new ServerboundTriggerAnimationPacket(stack, GeoItem.getId((ItemStack)stack), "controller", "stab"));
                } else {
                    PacketHandler.sendToServer(new ServerboundTriggerAnimationPacket(stack, GeoItem.getId((ItemStack)stack), "controller", "swing"));
                }
            } else if (item instanceof MurasamaSword) {
                FlatParticleData data;
                if (hand.combo().current() == 1) {
                    data = new FlatParticleData((ParticleType)BrutalityModParticles.MURASAMA_SLASH_PARTICLE.get(), 7.0f, Mth.m_14177_((float)(player.m_5686_(1.0f) - 20.0f)), BetterCombatIntegration.remapYaw(Mth.m_14177_((float)player.m_5675_(1.0f))), -30.0f, 0.0f, player.m_20206_() / 2.0f, 0.0f, player.m_19879_());
                    PacketHandler.sendToServer(new ClientboundExactParticlePacket(player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), data));
                }
                if (hand.combo().current() == 2) {
                    data = new FlatParticleData((ParticleType)BrutalityModParticles.MURASAMA_SLASH_PARTICLE.get(), 7.0f, Mth.m_14177_((float)player.m_5686_(1.0f)), BetterCombatIntegration.remapYaw(Mth.m_14177_((float)player.m_5675_(1.0f))), 180.0f, 0.0f, player.m_20206_() / 2.0f, 0.0f, player.m_19879_());
                    PacketHandler.sendToServer(new ClientboundExactParticlePacket(player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), data));
                }
            } else if (item instanceof AtomicJudgementHammer) {
                PacketHandler.sendToServer(new ServerboundTriggerAnimationPacket(stack, GeoItem.getId((ItemStack)stack), "controller", "attack"));
            } else if (item instanceof BrutalityThrowingItem) {
                BrutalityThrowingItem throwingItem = (BrutalityThrowingItem)item;
                throwingItem.handleCooldownAndSound((Player)player, stack);
            }
        });
    }

    public static float remapYaw(float playerYaw) {
        return ((-playerYaw + 180.0f) % 360.0f + 360.0f) % 360.0f - 180.0f;
    }
}

