/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.goo.brutality.entity.spells.cosmic.StarStreamEntity;
import net.goo.brutality.registry.BrutalityModEntities;
import net.goo.brutality.registry.BrutalityModSounds;
import net.goo.brutality.registry.ModAttributes;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemDecorator;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class SealUtils
implements IItemDecorator {
    private static final String SEAL = "seal";

    public boolean render(GuiGraphics guiGraphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        SEAL_TYPE sealType = SealUtils.getSealType(stack);
        if (sealType != null) {
            ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)"brutality", (String)("textures/gui/seals/" + sealType.toString().toLowerCase(Locale.ROOT) + "_seal.png"));
            guiGraphics.m_280163_(texture, xOffset, yOffset, 0.0f, 0.0f, 16, 16, 16, 16);
            return false;
        }
        return false;
    }

    public static SEAL_TYPE getSealType(ItemStack stack) {
        if (stack == null || stack.m_41619_() || !stack.m_41782_()) {
            return null;
        }
        String seal = stack.m_41784_().m_128461_(SEAL);
        if (seal.isEmpty()) {
            return null;
        }
        try {
            return SEAL_TYPE.valueOf(seal.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void handleSealAttributes(SEAL_TYPE sealType, ItemStack stack, EquipmentSlot slot, CallbackInfoReturnable<Multimap<Attribute, AttributeModifier>> cir) {
        if (sealType != null && slot == LivingEntity.m_147233_((ItemStack)stack)) {
            Multimap modifiers = (Multimap)cir.getReturnValue();
            ArrayListMultimap newModifiers = ArrayListMultimap.create((Multimap)modifiers);
            UUID modifierUUID = UUID.nameUUIDFromBytes(("seal_" + sealType.name() + "_" + slot.m_20751_()).getBytes());
            switch (sealType) {
                case BLACK: {
                    newModifiers.put((Object)((Attribute)ModAttributes.LETHALITY.get()), (Object)new AttributeModifier(modifierUUID, "black_seal", 2.0, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case BLUE: {
                    newModifiers.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(modifierUUID, "blue_seal", 3.0, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case GREEN: {
                    newModifiers.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(modifierUUID, "green_seal", 1.0, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case ORANGE: {
                    newModifiers.put((Object)((Attribute)ModAttributes.CRITICAL_STRIKE_CHANCE.get()), (Object)new AttributeModifier(modifierUUID, "orange_seal", (double)0.05f, AttributeModifier.Operation.MULTIPLY_BASE));
                    break;
                }
                case PINK: {
                    newModifiers.put((Object)((Attribute)ModAttributes.LIFESTEAL.get()), (Object)new AttributeModifier(modifierUUID, "pink_seal", (double)0.05f, AttributeModifier.Operation.MULTIPLY_BASE));
                    break;
                }
                case PURPLE: {
                    newModifiers.put((Object)((Attribute)ModAttributes.TENACITY.get()), (Object)new AttributeModifier(modifierUUID, "purple_seal", (double)0.15f, AttributeModifier.Operation.MULTIPLY_BASE));
                    break;
                }
                case RED: {
                    newModifiers.put((Object)Attributes.f_22276_, (Object)new AttributeModifier(modifierUUID, "red_seal", 3.0, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case CYAN: {
                    newModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(modifierUUID, "teal_seal", 3.0, AttributeModifier.Operation.ADDITION));
                    break;
                }
                case YELLOW: {
                    newModifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(modifierUUID, "yellow_seal", (double)0.1f, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    break;
                }
                case QUANTITE: {
                    newModifiers.put((Object)((Attribute)ModAttributes.ARMOR_PENETRATION.get()), (Object)new AttributeModifier(modifierUUID, "quantite_seal", (double)0.05f, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    break;
                }
                case GLASS: {
                    newModifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(modifierUUID, "glass_seal", (double)0.35f, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    newModifiers.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(modifierUUID, "glass_seal", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    newModifiers.put((Object)((Attribute)ModAttributes.DAMAGE_TAKEN.get()), (Object)new AttributeModifier(modifierUUID, "glass_seal", 0.25, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
            cir.setReturnValue((Object)newModifiers);
        }
    }

    public static void addSeal(ItemStack stack, SEAL_TYPE type) {
        stack.m_41784_().m_128359_(SEAL, type.name());
    }

    public static void handleSealProc(Level level, LivingEntity attacker, Vec3 location, @Nullable SEAL_TYPE sealType) {
        if (sealType != null) {
            RandomSource random = level.m_213780_();
            switch (sealType) {
                case BOMB: {
                    level.m_254849_((Entity)attacker, location.m_7096_(), location.m_7098_(), location.m_7094_(), 0.25f, Level.ExplosionInteraction.NONE);
                    break;
                }
                case COSMIC: {
                    StarStreamEntity spellEntity = new StarStreamEntity((EntityType<? extends AbstractArrow>)((EntityType)BrutalityModEntities.STAR_STREAM_ENTITY.get()), level);
                    spellEntity.setSpellLevel(0);
                    Vec3 randomPos = location.m_82520_((double)Mth.m_216283_((RandomSource)attacker.m_217043_(), (float)-1.0f, (float)1.0f), (double)Mth.m_216283_((RandomSource)attacker.m_217043_(), (float)7.5f, (float)12.0f), (double)Mth.m_216283_((RandomSource)attacker.m_217043_(), (float)-1.0f, (float)1.0f));
                    spellEntity.m_146884_(randomPos);
                    spellEntity.m_5602_((Entity)attacker);
                    Vec3 direction = location.m_82546_(randomPos).m_82541_();
                    spellEntity.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, 1.5f, 1.5f);
                    level.m_7967_((Entity)spellEntity);
                    level.m_6263_(null, attacker.m_20185_(), attacker.m_20227_(0.5), attacker.m_20189_(), (SoundEvent)BrutalityModSounds.BASS_BOP.get(), SoundSource.AMBIENT, 1.5f, Mth.m_216267_((RandomSource)random, (float)0.7f, (float)1.2f));
                }
            }
        }
    }

    public static void handleSealProc(Level level, LivingEntity attacker, Vec3 location, ItemStack stack) {
        SEAL_TYPE sealType = SealUtils.getSealType(stack);
        SealUtils.handleSealProc(level, attacker, location, sealType);
    }

    public static enum SEAL_TYPE {
        NONE(false),
        BLACK(false),
        BLUE(false),
        GREEN(false),
        ORANGE(false),
        PINK(false),
        PURPLE(false),
        RED(false),
        CYAN(false),
        YELLOW(false),
        BOMB(true),
        GLASS(false),
        QUANTITE(false),
        VOID(true),
        COSMIC(true);

        private final boolean showDescription;

        private SEAL_TYPE(boolean showDescription) {
            this.showDescription = showDescription;
        }

        public Boolean showDescription() {
            return this.showDescription;
        }
    }
}

