/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.util.helpers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.goo.brutality.entity.explosion.BrutalityExplosion;
import net.goo.brutality.network.ClientboundBrutalityExplodePacket;
import net.goo.brutality.network.PacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ModExplosionHelper {

    @Mod.EventBusSubscriber(modid="brutality", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.DEDICATED_SERVER})
    public static class Server {
        private static final List<ProgressiveExplosion> activeExplosions = new ArrayList<ProgressiveExplosion>();

        public static void addExplosion(Level level, Entity owner, BlockPos center, float radius, int layersPerTick) {
            activeExplosions.add(new ProgressiveExplosion(level, owner, center, radius, layersPerTick));
            level.m_7471_(center, false);
        }

        @SubscribeEvent
        public static void onServerTick(TickEvent.ServerTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                activeExplosions.removeIf(ProgressiveExplosion::tick);
            }
        }

        public static Explosion explode(BrutalityExplosion explosion, Level level, boolean spawnParticles) {
            if (level instanceof ServerLevel) {
                Explosion.BlockInteraction blockInteraction;
                ServerLevel serverLevel = (ServerLevel)level;
                switch (explosion.getExplosionInteraction()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case NONE: {
                        Explosion.BlockInteraction blockInteraction2 = Explosion.BlockInteraction.KEEP;
                        break;
                    }
                    case BLOCK: {
                        Explosion.BlockInteraction blockInteraction2 = level.m_255157_(GameRules.f_254629_);
                        break;
                    }
                    case MOB: {
                        Explosion.BlockInteraction blockInteraction2;
                        if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)explosion.m_253049_())) {
                            blockInteraction2 = level.m_255157_(GameRules.f_254692_);
                            break;
                        }
                        blockInteraction2 = Explosion.BlockInteraction.KEEP;
                        break;
                    }
                    case TNT: {
                        Explosion.BlockInteraction blockInteraction2 = blockInteraction = level.m_255157_(GameRules.f_254705_);
                    }
                }
                if (ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
                    return explosion;
                }
                explosion.f_46010_ = blockInteraction;
                explosion.m_46061_();
                explosion.m_46075_(spawnParticles);
                if (!explosion.m_254884_()) {
                    explosion.m_46080_();
                }
                for (ServerPlayer serverplayer : serverLevel.m_8795_(serverPlayer -> serverPlayer.m_20238_(explosion.getPosition()) < 4096.0)) {
                    PacketHandler.sendToPlayer((Object)new ClientboundBrutalityExplodePacket(explosion.getPosition().f_82479_, explosion.getPosition().f_82480_, explosion.getPosition().f_82481_, explosion.getRadius(), explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverplayer), spawnParticles, ((Object)((Object)explosion)).getClass()), serverplayer);
                }
            }
            return explosion;
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Client {
        public static void handleExplosion(ClientboundBrutalityExplodePacket packet) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            if (level == null) {
                return;
            }
            try {
                Class<?> explosionClass = Class.forName(packet.getClazz());
                Constructor<?> constructor = explosionClass.getConstructor(Level.class, Entity.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, List.class);
                BrutalityExplosion explosion = (BrutalityExplosion)((Object)constructor.newInstance(level, null, packet.m_132132_(), packet.m_132133_(), packet.m_132134_(), Float.valueOf(packet.m_132135_()), packet.m_132136_()));
                explosion.m_46061_();
                explosion.m_46075_(packet.isSpawnParticles());
                if (mc.f_91074_ == null) {
                    return;
                }
                mc.f_91074_.m_20256_(mc.f_91074_.m_20184_().m_82520_((double)packet.m_132127_(), (double)packet.m_132130_(), (double)packet.m_132131_()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                Explosion explosion = new Explosion((Level)level, null, packet.m_132132_(), packet.m_132133_(), packet.m_132134_(), packet.m_132135_(), packet.m_132136_());
                explosion.m_46075_(packet.isSpawnParticles());
                if (mc.f_91074_ == null) {
                    return;
                }
                mc.f_91074_.m_20256_(mc.f_91074_.m_20184_().m_82520_((double)packet.m_132127_(), (double)packet.m_132130_(), (double)packet.m_132131_()));
            }
        }
    }

    public static class ProgressiveExplosion {
        private final Level level;
        private final Entity owner;
        private final BlockPos center;
        private final float maxRadius;
        private float currentRadius = 0.0f;
        private int ticksSinceLastLayer = 0;
        private final int layersPerTick;
        private int tickDelay = 4;

        public ProgressiveExplosion(Level level, Entity owner, BlockPos center, float maxRadius, int layersPerTick) {
            this.level = level;
            this.owner = owner;
            this.center = center;
            this.maxRadius = maxRadius;
            this.layersPerTick = layersPerTick;
        }

        public boolean tick() {
            if (this.currentRadius >= this.maxRadius) {
                return true;
            }
            ++this.ticksSinceLastLayer;
            if (this.ticksSinceLastLayer >= this.tickDelay) {
                this.destroyLayer(this.currentRadius, this.layersPerTick);
                this.currentRadius += (float)this.layersPerTick;
                this.ticksSinceLastLayer = 0;
            }
            return false;
        }

        private void destroyLayer(float startRadius, int layersToDestroy) {
            int endRadiusInt = (int)Math.ceil(startRadius + (float)layersToDestroy);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int x = -endRadiusInt; x <= endRadiusInt; ++x) {
                for (int y = -endRadiusInt; y <= endRadiusInt; ++y) {
                    block2: for (int z = -endRadiusInt; z <= endRadiusInt; ++z) {
                        double distanceSq = x * x + y * y + z * z;
                        for (int l = 0; l < layersToDestroy; ++l) {
                            float currentLayer = startRadius + (float)l;
                            double outerSq = currentLayer * currentLayer;
                            double innerSq = (currentLayer - 1.0f) * (currentLayer - 1.0f);
                            if (!(distanceSq > innerSq) || !(distanceSq <= outerSq)) continue;
                            mutablePos.m_122178_(this.center.m_123341_() + x, this.center.m_123342_() + y, this.center.m_123343_() + z);
                            if (this.level.m_8055_((BlockPos)mutablePos).m_60795_()) continue;
                            this.level.m_7471_((BlockPos)mutablePos, false);
                            continue block2;
                        }
                    }
                }
            }
            if (startRadius + (float)layersToDestroy >= this.maxRadius) {
                AABB searchArea = new AABB(this.center).m_82400_((double)(startRadius + (float)layersToDestroy));
                List entities = this.level.m_45976_(Entity.class, searchArea);
                for (Entity target : entities) {
                    double distanceSq = target.m_20275_((double)this.center.m_123341_(), (double)this.center.m_123342_(), (double)this.center.m_123343_());
                    if (!(distanceSq <= (double)((startRadius + (float)layersToDestroy) * (startRadius + (float)layersToDestroy)))) continue;
                    float damage = this.calculateDamage(distanceSq, startRadius + (float)layersToDestroy);
                    target.m_6469_(target.m_269291_().m_269036_(this.owner, target), damage);
                }
            }
        }

        private float calculateDamage(double distanceSq, float currentRadius) {
            return (float)((double)(this.maxRadius / 3.0f) * (1.0 - Math.sqrt(distanceSq) / (double)this.maxRadius) * (double)(currentRadius / this.maxRadius));
        }
    }
}

