/*
 * Decompiled with CFR 0.152.
 */
package net.goo.brutality.block.block_entity;

import net.goo.brutality.block.FilingCabinetOpenersCounter;
import net.goo.brutality.block.block_entity.FilingCabinetDrawerSlideController;
import net.goo.brutality.block.custom.WhiteFilingCabinetBlock;
import net.goo.brutality.gui.menu.FilingCabinetMenu;
import net.goo.brutality.registry.BrutalityModBlockEntities;
import net.mcreator.terramity.item.CardboardItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class WhiteFilingCabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private final int INVENTORY_SIZE = 42;
    private NonNullList<ItemStack> upperInventory = NonNullList.m_122780_((int)42, (Object)ItemStack.f_41583_);
    private NonNullList<ItemStack> lowerInventory = NonNullList.m_122780_((int)42, (Object)ItemStack.f_41583_);
    private final FilingCabinetDrawerSlideController upperDrawerController = new FilingCabinetDrawerSlideController(true);
    private final FilingCabinetDrawerSlideController lowerDrawerController = new FilingCabinetDrawerSlideController(false);
    private final FilingCabinetOpenersCounter openersCounter = new FilingCabinetOpenersCounter(this);

    public WhiteFilingCabinetBlockEntity(BlockEntityType<? extends WhiteFilingCabinetBlockEntity> entityType, BlockPos pPos, BlockState pBlockState) {
        super(entityType, pPos, pBlockState);
    }

    public static WhiteFilingCabinetBlockEntity create(BlockPos pos, BlockState state) {
        return new WhiteFilingCabinetBlockEntity((BlockEntityType<? extends WhiteFilingCabinetBlockEntity>)((BlockEntityType)BrutalityModBlockEntities.WHITE_FILING_CABINET_BLOCK_ENTITY.get()), pos, state);
    }

    public NonNullList<ItemStack> getUpperInventory() {
        return this.upperInventory;
    }

    public NonNullList<ItemStack> getLowerInventory() {
        return this.lowerInventory;
    }

    public float getOpenness(boolean isUpper, float partialTicks) {
        return isUpper ? this.upperDrawerController.getOpenness(partialTicks) : this.lowerDrawerController.getOpenness(partialTicks);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        if (!this.m_59634_(pTag)) {
            WhiteFilingCabinetBlockEntity.saveAllItems(pTag, this.upperInventory, "UpperInventory");
            WhiteFilingCabinetBlockEntity.saveAllItems(pTag, this.lowerInventory, "LowerInventory");
        }
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pStack.m_150930_(Items.f_42516_) || pStack.m_204117_(ItemTags.f_13162_) || pStack.m_150930_(Items.f_42690_) || pStack.m_150930_(Items.f_42517_) || pStack.m_41720_() instanceof CardboardItem;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.upperInventory = NonNullList.m_122780_((int)(this.m_6643_() / 2), (Object)ItemStack.f_41583_);
        this.lowerInventory = NonNullList.m_122780_((int)(this.m_6643_() / 2), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(pTag)) {
            WhiteFilingCabinetBlockEntity.loadAllItems(pTag, this.upperInventory, "UpperInventory");
            WhiteFilingCabinetBlockEntity.loadAllItems(pTag, this.lowerInventory, "LowerInventory");
        }
    }

    private static void loadAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, String key) {
        ListTag listtag = pTag.m_128437_(key, 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j >= pList.size()) continue;
            pList.set(j, (Object)ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    private static void saveAllItems(CompoundTag pTag, NonNullList<ItemStack> pList, String key) {
        ListTag listtag = new ListTag();
        for (int i = 0; i < pList.size(); ++i) {
            ItemStack itemstack = (ItemStack)pList.get(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        pTag.m_128365_(key, (Tag)listtag);
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.upperInventory;
    }

    @NotNull
    public ItemStack m_8020_(int pIndex) {
        NonNullList<ItemStack> inventory = pIndex < 42 ? this.upperInventory : this.lowerInventory;
        return (ItemStack)inventory.get(pIndex % 42);
    }

    @NotNull
    public ItemStack m_7407_(int pIndex, int pCount) {
        this.m_59640_(null);
        NonNullList<ItemStack> inventory = pIndex < 42 ? this.upperInventory : this.lowerInventory;
        ItemStack stack = ContainerHelper.m_18969_(inventory, (int)(pIndex % 42), (int)pCount);
        this.m_6596_();
        return stack;
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.m_59640_(null);
        NonNullList<ItemStack> inventory = pIndex < 42 ? this.upperInventory : this.lowerInventory;
        inventory.set(pIndex % 42, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6211_() {
        this.upperInventory.clear();
        this.lowerInventory.clear();
        this.m_6596_();
    }

    @NotNull
    public ItemStack m_8016_(int pIndex) {
        this.m_59640_(null);
        int relativeIndex = pIndex % 42;
        NonNullList<ItemStack> inventory = pIndex < 42 ? this.upperInventory : this.lowerInventory;
        ItemStack stack = (ItemStack)inventory.get(relativeIndex);
        inventory.set(relativeIndex, (Object)ItemStack.f_41583_);
        this.m_6596_();
        return stack;
    }

    protected void m_6520_(NonNullList<ItemStack> pItemStacks) {
        int i;
        if (pItemStacks.size() != 84) {
            // empty if block
        }
        for (i = 0; i < 42; ++i) {
            this.upperInventory.set(i, (Object)((ItemStack)pItemStacks.get(i)));
        }
        for (i = 0; i < 42; ++i) {
            this.lowerInventory.set(i, (Object)((ItemStack)pItemStacks.get(i + 42)));
        }
        this.m_6596_();
    }

    public void startOpen(Player pPlayer, boolean isUpper) {
        if (!this.f_58859_ && !pPlayer.m_5833_() && this.m_58904_() != null) {
            this.openersCounter.incrementOpeners(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_(), isUpper);
        }
    }

    public void stopOpen(Player pPlayer, boolean isUpper) {
        if (!this.f_58859_ && !pPlayer.m_5833_() && this.m_58904_() != null) {
            this.openersCounter.decrementOpeners(pPlayer, this.m_58904_(), this.m_58899_(), this.m_58900_(), isUpper);
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_ && this.m_58904_() != null) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? WhiteFilingCabinetBlockEntity.createTickerHelper(blockEntityType, (BlockEntityType)BrutalityModBlockEntities.WHITE_FILING_CABINET_BLOCK_ENTITY.get(), WhiteFilingCabinetBlockEntity::tickDrawer) : null;
    }

    static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    static void tickDrawer(Level level, BlockPos pos, BlockState state, WhiteFilingCabinetBlockEntity blockEntity) {
        blockEntity.upperDrawerController.tickDrawer((Boolean)state.m_61143_((Property)WhiteFilingCabinetBlock.UPPER_OPEN));
        blockEntity.lowerDrawerController.tickDrawer((Boolean)state.m_61143_((Property)WhiteFilingCabinetBlock.LOWER_OPEN));
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.brutality.filing_cabinet");
    }

    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new FilingCabinetMenu(pContainerId, pInventory, this, true);
    }

    public int m_6643_() {
        return 84;
    }

    public void updateBlockState(BlockState pState, boolean isUpper, boolean pOpen) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)pState.m_61124_((Property)(isUpper ? WhiteFilingCabinetBlock.UPPER_OPEN : WhiteFilingCabinetBlock.LOWER_OPEN), (Comparable)Boolean.valueOf(pOpen)), 3);
        }
    }
}

